/**
 * Copyright IBM Corp. 2024
 *
 * This source code is licensed under the Apache-2.0 license found in the
 * LICENSE file in the root directory of this source tree.
 */

import { svg } from 'lit';
import spread from '../../globals/directives/spread.js';

const svgResultCarbonIcon = ({ children, ...attrs } = {}) => svg`<svg focusable="false" preserveAspectRatio="xMidYMid meet" xmlns="http://www.w3.org/2000/svg" fill="currentColor" ...="${spread(attrs)}" aria-hidden="true" width="24" height="24" viewBox="0 0 32 32">${children}<path stroke-width="0" d="m16,4.2407l11.8274,8.6831-4.5261,14.0762h-14.6025l-4.5261-14.0762,11.8274-8.6831m0-2.2407c-.2078,0-.4158.0645-.5918.1938L2.4082,11.7383c-.2599.1907-.4066.4904-.4082.8009-.0005.1036.0151.2085.0481.3109l4.9697,15.4561c.1331.4136.5176.6938.9519.6938h16.0605c.4343,0,.8188-.2803.9519-.6938l4.9697-15.4561c.0329-.1021.0485-.2067.0481-.31-.0013-.3108-.1481-.6109-.4082-.8018L16.5918,2.1938c-.176-.1294-.384-.1938-.5918-.1938h0Z"></path></svg>`;
export default svgResultCarbonIcon;