/**
 * Copyright IBM Corp. 2024
 *
 * This source code is licensed under the Apache-2.0 license found in the
 * LICENSE file in the root directory of this source tree.
 */

import { svg } from 'lit';
import spread from '../../globals/directives/spread.js';

const svgResultCarbonIcon = ({ children, ...attrs } = {}) => svg`<svg focusable="false" preserveAspectRatio="xMidYMid meet" xmlns="http://www.w3.org/2000/svg" fill="currentColor" ...="${spread(attrs)}" aria-hidden="true" width="32" height="32" viewBox="0 0 32 32">${children}<path stroke-width="0" d="m27.7593,16l-8.6831,11.8274-14.0762-4.5261v-14.6025l14.0762-4.5261,8.6831,11.8274m2.2407,0c0-.2078-.0645-.4158-.1938-.5918L20.2617,2.4082c-.1907-.2599-.4904-.4066-.8009-.4082-.1036-.0005-.2085.0151-.3109.0481L3.6938,7.0178c-.4136.1331-.6938.5176-.6938.9519v16.0605c0,.4343.2803.8188.6938.9519l15.4561,4.9697c.1021.0329.2067.0485.31.0481.3108-.0013.6109-.1481.8018-.4082l9.5444-13c.1294-.176.1938-.384.1938-.5918h0Z"></path></svg>`;
export default svgResultCarbonIcon;