/**
 * Copyright IBM Corp. 2024
 *
 * This source code is licensed under the Apache-2.0 license found in the
 * LICENSE file in the root directory of this source tree.
 */

import { svg } from 'lit';
import spread from '../../globals/directives/spread.js';

const svgResultCarbonIcon = ({ children, ...attrs } = {}) => svg`<svg focusable="false" preserveAspectRatio="xMidYMid meet" xmlns="http://www.w3.org/2000/svg" fill="currentColor" ...="${spread(attrs)}" aria-hidden="true" width="32" height="32" viewBox="0 0 32 32">${children}<path d="M9,14a5,5,0,1,1,5-5A5.0055,5.0055,0,0,1,9,14Z"></path><path d="M0.029 15H31.97V17H0.029z" transform="rotate(-45 16 16)"></path><path d="M23,28a5,5,0,1,1,5-5A5.0055,5.0055,0,0,1,23,28Z"></path></svg>`;
export default svgResultCarbonIcon;