/**
 * Copyright IBM Corp. 2024
 *
 * This source code is licensed under the Apache-2.0 license found in the
 * LICENSE file in the root directory of this source tree.
 */

import { svg } from 'lit';
import spread from '../../globals/directives/spread.js';

const svgResultCarbonIcon = ({ children, ...attrs } = {}) => svg`<svg focusable="false" preserveAspectRatio="xMidYMid meet" xmlns="http://www.w3.org/2000/svg" fill="currentColor" ...="${spread(attrs)}" aria-hidden="true" width="32" height="32" viewBox="0 0 32 32">${children}<path stroke-width="0" d="M27 21h-2c0-2.8226 0-7.0881-10.0903-8.0042l.1807-1.9917c11.9097 1.0811 11.9097 6.8802 11.9097 9.9958zM16.9097 20.9958c-11.9097-1.0811-11.9097-6.8802-11.9097-9.9958h2c0 2.8226 0 7.0881 10.0903 8.0042l-.1807 1.9917z"></path><path stroke-width="0" d="m23,20.52c0-4.62-3.78-5.14-6.82-5.56-3.31-.46-5.18-.86-5.18-3.71,0-2.39,2.51-3.24,4.65-3.24,2.32,0,4.14.86,5.57,2.63l1.56-1.26c-1.52-1.88-3.46-2.97-5.78-3.28v-3.1h-2v3.02c-3.62.22-6,2.26-6,5.22,0,4.73,3.83,5.26,6.91,5.69,3.25.45,5.09.84,5.09,3.58,0,3.03-3.13,3.48-5,3.48-3.43,0-4.88-.96-6.22-2.63l-1.56,1.26c1.77,2.19,3.73,3.17,6.78,3.34v3.04h2v-3.04c3.73-.3,6-2.33,6-5.44Z"></path></svg>`;
export default svgResultCarbonIcon;