/**
 * Copyright IBM Corp. 2024
 *
 * This source code is licensed under the Apache-2.0 license found in the
 * LICENSE file in the root directory of this source tree.
 */

import { svg } from 'lit';
import spread from '../../globals/directives/spread.js';

const svgResultCarbonIcon = ({ children, ...attrs } = {}) => svg`<svg focusable="false" preserveAspectRatio="xMidYMid meet" xmlns="http://www.w3.org/2000/svg" fill="currentColor" ...="${spread(attrs)}" aria-hidden="true" width="20" height="20" viewBox="0 0 32 32">${children}<path stroke-width="0" d="m17,15.0698v-6.9536c1.6909.2793,3.084,1.1021,4.2219,2.5117l1.5562-1.2559c-1.5195-1.8823-3.4619-2.9736-5.7781-3.2759v-3.0962h-2v3.022c-3.6152.2192-6,2.2603-6,5.2202,0,4.2739,3.1265,5.1191,6,5.5586v7.1616c-2.7192-.1777-4.0186-1.1001-5.2219-2.5903l-1.5562,1.2559c1.7703,2.1934,3.7332,3.168,6.7781,3.3369v3.0352h2v-3.0449c3.7256-.3042,6-2.3271,6-5.4399,0-4.209-3.1428-5.0156-6-5.4453Zm-6-3.8276c0-2.1533,2.0293-3.0537,4-3.2134v6.7466c-2.5696-.4238-4-1.043-4-3.5332Zm6,12.71v-6.8574c2.5669.4155,4,1.0044,4,3.4204,0,2.5361-2.1902,3.2656-4,3.437Z"></path></svg>`;
export default svgResultCarbonIcon;