/**
 * Copyright IBM Corp. 2024
 *
 * This source code is licensed under the Apache-2.0 license found in the
 * LICENSE file in the root directory of this source tree.
 */

import { svg } from 'lit';
import spread from '../../globals/directives/spread.js';

const svgResultCarbonIcon = ({ children, ...attrs } = {}) => svg`<svg focusable="false" preserveAspectRatio="xMidYMid meet" xmlns="http://www.w3.org/2000/svg" fill="currentColor" ...="${spread(attrs)}" aria-hidden="true" width="24" height="24" viewBox="0 0 32 32">${children}<path stroke-width="0" d="M25 22.1421v-13.1421c0-2.2056-1.7944-4-4-4h-4.1719l2.5859-2.5859-1.4141-1.4141-5 5 5 5 1.4141-1.4141-2.5859-2.5859h4.1719c1.1028 0 2 .8975 2 2v13.1421c-1.7202.4473-3 1.9995-3 3.8579 0 2.2056 1.7944 4 4 4s4-1.7944 4-4c0-1.8584-1.2798-3.4106-3-3.8579zm-1 5.8579c-1.1028 0-2-.8975-2-2s.8972-2 2-2 2 .8975 2 2-.8972 2-2 2zM4 6c0 1.8584 1.2798 3.4106 3 3.8579v12.2842c-1.7202.447-3 1.9993-3 3.8579 0 2.2061 1.7944 4 4 4s4-1.7939 4-4c0-1.8586-1.2798-3.4109-3-3.8579v-12.2842c1.7202-.4473 3-1.9995 3-3.8579 0-2.2056-1.7944-4-4-4s-4 1.7944-4 4zm6 20c0 1.1025-.897 2-2 2s-2-.8975-2-2c0-1.1025.897-2 2-2s2 .8975 2 2zm0-20c0 1.103-.897 2-2 2s-2-.897-2-2c0-1.103.897-2 2-2s2 .897 2 2z"></path></svg>`;
export default svgResultCarbonIcon;