/**
 * Copyright IBM Corp. 2024
 *
 * This source code is licensed under the Apache-2.0 license found in the
 * LICENSE file in the root directory of this source tree.
 */

import { svg } from 'lit';
import spread from '../../globals/directives/spread.js';

const svgResultCarbonIcon = ({ children, ...attrs } = {}) => svg`<svg focusable="false" preserveAspectRatio="xMidYMid meet" xmlns="http://www.w3.org/2000/svg" fill="currentColor" ...="${spread(attrs)}" aria-hidden="true" width="16" height="16" viewBox="0 0 32 32">${children}<path stroke-width="0" d="m16,1C7.729,1,1,7.729,1,16s6.729,15,15,15,15-6.729,15-15S24.271,1,16,1Zm6.5825,20.5c-.5203-.8926-1.4771-1.5-2.5825-1.5-.1821,0-.3586.0225-.532.0537l-1.7258-3.0205c6.7866.2388,10.1216,1.8262,10.2571,2.4668-.0979.4624-1.8899,1.4141-5.4167,2Zm-2.5825.5c.5515,0,1,.4487,1,1s-.4485,1-1,1-1-.4487-1-1,.4485-1,1-1ZM3,16c0-.5435.0442-1.0762.1094-1.6025.8552.666,2.1555,1.1973,3.7239,1.6025-1.5684.4053-2.8687.9365-3.7239,1.6025-.0652-.5264-.1094-1.0591-.1094-1.6025Zm6.4175-5.4995c.5205.8921,1.4773,1.4995,2.5825,1.4995.1821,0,.3586-.0225.532-.0537l1.7258,3.0205c-6.8042-.2393-10.1387-1.8335-10.2581-2.4619.0862-.4609,1.8784-1.416,5.4177-2.0044Zm2.5825-.5005c-.5515,0-1-.4487-1-1s.4485-1,1-1,1,.4487,1,1-.4485,1-1,1Zm13.167,6c1.5681-.4053,2.8684-.9365,3.7236-1.6025.0652.5264.1094,1.0591.1094,1.6025s-.0442,1.0762-.1094,1.6025c-.8552-.666-2.1555-1.1973-3.7236-1.6025ZM16,3c4.9019,0,9.1758,2.7285,11.3901,6.7451-2.2891-.9961-5.7993-1.5513-9.3901-1.6997v1.999c6.6108.2695,9.8655,1.8232,9.9993,2.4556-.1431.6763-3.8533,2.4062-11.4236,2.4917l-2.3118-4.0454c.4524-.5254.7361-1.2002.7361-1.9463,0-1.6543-1.3457-3-3-3-1.4956,0-2.7285,1.1035-2.9531,2.5371-1.7056.2837-3.2363.6841-4.4351,1.2051,2.2151-4.0146,6.4878-6.7422,11.3882-6.7422Zm0,26c-4.9019,0-9.1758-2.7285-11.3901-6.7451,2.2891.9961,5.7993,1.5513,9.3901,1.6997v-1.999c-6.6282-.2705-9.8823-1.8306-10.0002-2.4507.126-.6729,3.8357-2.4106,11.4246-2.4966l2.3118,4.0454c-.4524.5254-.7361,1.2002-.7361,1.9463,0,1.6543,1.3457,3,3,3,1.4956,0,2.7285-1.1035,2.9531-2.5371,1.7056-.2837,3.2363-.6841,4.4351-1.2051-2.2151,4.0146-6.4878,6.7422-11.3882,6.7422Z"></path></svg>`;
export default svgResultCarbonIcon;