/**
 * Copyright IBM Corp. 2024
 *
 * This source code is licensed under the Apache-2.0 license found in the
 * LICENSE file in the root directory of this source tree.
 */

import { svg } from 'lit';
import spread from '../../globals/directives/spread.js';

const svgResultCarbonIcon = ({ children, ...attrs } = {}) => svg`<svg focusable="false" preserveAspectRatio="xMidYMid meet" xmlns="http://www.w3.org/2000/svg" fill="currentColor" ...="${spread(attrs)}" aria-hidden="true" width="20" height="20" viewBox="0 0 32 32">${children}<path d="M30,3.4146,28.5854,2,17.2932,13.2925a1,1,0,1,0,1.4141,1.414l3.4543-3.4541A4.9817,4.9817,0,0,1,18,19a5.0385,5.0385,0,0,1-.6074-.05,8.0432,8.0432,0,0,0-4.3421-4.3423A4.9,4.9,0,0,1,18,9V7a7.0078,7.0078,0,0,0-7,7c0,.0234.0056.0469.0059.07A8.0469,8.0469,0,0,0,10,14a7.95,7.95,0,0,0-1.9883.26C8.0095,14.1729,8,14.0879,8,14A10.0114,10.0114,0,0,1,18,4V2A12.0137,12.0137,0,0,0,6,14c0,.355.0171.7061.0471,1.0537A7.9943,7.9943,0,1,0,16.9465,25.9521c.35.03.7019.0479,1.0535.0479A11.9853,11.9853,0,0,0,27.1538,6.2607ZM15.91,21H13.9563a12.029,12.029,0,0,0-1.218-4.332A6.01,6.01,0,0,1,15.91,21ZM4.09,23H6.0435a12.0318,12.0318,0,0,0,1.2182,4.3325A6.01,6.01,0,0,1,4.09,23Zm1.9532-2H4.09a6.01,6.01,0,0,1,3.1714-4.332A12.0321,12.0321,0,0,0,6.0435,21ZM10,27.9858A10.0149,10.0149,0,0,1,8.0552,23h3.89A10.0149,10.0149,0,0,1,10,27.9858ZM8.0552,21A10.0118,10.0118,0,0,1,10,16.0151,10.01,10.01,0,0,1,11.9448,21Zm4.6831,6.3325A12.0318,12.0318,0,0,0,13.9565,23H15.91A6.01,6.01,0,0,1,12.7383,27.3325ZM28,14A10.0114,10.0114,0,0,1,18,24c-.0869,0-.1733-.01-.26-.0117a7.5527,7.5527,0,0,0,.19-2.9942c.0237,0,.0466.0059.07.0059A6.9991,6.9991,0,0,0,23.6055,9.8086l2.1313-2.1314A9.95,9.95,0,0,1,28,14Z"></path></svg>`;
export default svgResultCarbonIcon;