/**
 * Copyright IBM Corp. 2024
 *
 * This source code is licensed under the Apache-2.0 license found in the
 * LICENSE file in the root directory of this source tree.
 */

import { svg } from 'lit';
import spread from '../../globals/directives/spread.js';

const svgResultCarbonIcon = ({ children, ...attrs } = {}) => svg`<svg focusable="false" preserveAspectRatio="xMidYMid meet" xmlns="http://www.w3.org/2000/svg" fill="currentColor" ...="${spread(attrs)}" aria-hidden="true" width="32" height="32" viewBox="0 0 32 32">${children}<path d="M30,3.4141,28.5859,2,15.293,15.293a1,1,0,0,0,1.414,1.414l4.18-4.1792A5.9956,5.9956,0,1,1,16,10V8a8.011,8.011,0,1,0,6.3164,3.0977L25.1631,8.251A11.881,11.881,0,0,1,28,16,12,12,0,1,1,16,4V2A14,14,0,1,0,30,16a13.8572,13.8572,0,0,0-3.4224-9.1636Z"></path></svg>`;
export default svgResultCarbonIcon;