/**
 * Copyright IBM Corp. 2024
 *
 * This source code is licensed under the Apache-2.0 license found in the
 * LICENSE file in the root directory of this source tree.
 */

import { svg } from 'lit';
import spread from '../../globals/directives/spread.js';

const svgResultCarbonIcon = ({ children, ...attrs } = {}) => svg`<svg focusable="false" preserveAspectRatio="xMidYMid meet" xmlns="http://www.w3.org/2000/svg" fill="currentColor" ...="${spread(attrs)}" aria-hidden="true" width="24" height="24" viewBox="0 0 32 32">${children}<path stroke-width="0" d="M5 16h-2v11c0 1.1045.8954 2 2 2h8v-2H5v-11zM28 29h-11c-.3535 0-.6809-.1866-.8608-.4911-.0927-.1568-.1392-.3328-.1392-.5089 0-.1658.0412-.3317.1238-.4819l5.5-10c.1898-.3451.5333-.5178.8762-.5181.3434-.0003.6861.1724.8762.5181l5.5 10c.0826.1502.1238.3162.1238.4819 0 .1762-.0465.3521-.1392.5089-.1799.3044-.5073.4911-.8608.4911zm-9.3088-2h7.6177l-3.8088-6.9249-3.8088 6.9249zM27 3h-11v2h11v13.9922h2V5c0-1.1045-.8954-2-2-2zM11 3h-6c-1.1046 0-2 .8955-2 2v6c0 1.1045.8954 2 2 2h6c1.1046 0 2-.8955 2-2v-6c0-1.1045-.8954-2-2-2zm0 8h-6v-6h6v6z"></path></svg>`;
export default svgResultCarbonIcon;