/**
 * Copyright IBM Corp. 2024
 *
 * This source code is licensed under the Apache-2.0 license found in the
 * LICENSE file in the root directory of this source tree.
 */

import { svg } from 'lit';
import spread from '../../globals/directives/spread.js';

const svgResultCarbonIcon = ({ children, ...attrs } = {}) => svg`<svg focusable="false" preserveAspectRatio="xMidYMid meet" xmlns="http://www.w3.org/2000/svg" fill="currentColor" ...="${spread(attrs)}" aria-hidden="true" width="32" height="32" viewBox="0 0 32 32">${children}<path d="M30 5L30 8 22 8 22 26 19 26 19 8 11 8 11 5 30 5z"></path><path d="M7 26L7 14 2 14 2 12 14 12 14 14 9 14 9 26 7 26z"></path></svg>`;
export default svgResultCarbonIcon;