/**
 * Copyright IBM Corp. 2024
 *
 * This source code is licensed under the Apache-2.0 license found in the
 * LICENSE file in the root directory of this source tree.
 */

import { svg } from 'lit';
import spread from '../../globals/directives/spread.js';

const svgResultCarbonIcon = ({ children, ...attrs } = {}) => svg`<svg focusable="false" preserveAspectRatio="xMidYMid meet" xmlns="http://www.w3.org/2000/svg" fill="currentColor" ...="${spread(attrs)}" aria-hidden="true" width="16" height="16" viewBox="0 0 32 32">${children}<path d="M23 27L23 15 18 15 18 13 30 13 30 15 25 15 25 27 23 27z"></path><path d="M11 27L11 8 2 8 2 6 22 6 22 8 13 8 13 27 11 27z"></path></svg>`;
export default svgResultCarbonIcon;