/**
 * Copyright IBM Corp. 2024
 *
 * This source code is licensed under the Apache-2.0 license found in the
 * LICENSE file in the root directory of this source tree.
 */

import { svg } from 'lit';
import spread from '../../globals/directives/spread.js';

const svgResultCarbonIcon = ({ children, ...attrs } = {}) => svg`<svg focusable="false" preserveAspectRatio="xMidYMid meet" xmlns="http://www.w3.org/2000/svg" fill="currentColor" ...="${spread(attrs)}" aria-hidden="true" width="16" height="16" viewBox="0 0 32 32">${children}<path d="M11 21H17V23H11z"></path><path d="M24.2456,8,25.96,14H30V12H27.4688l-1.3-4.5488A2.0077,2.0077,0,0,0,24.2456,6H22.8972l-.7287-2.5488A2.0077,2.0077,0,0,0,20.2456,2H7.7544A2.0078,2.0078,0,0,0,5.8315,3.4507L4.5312,8H2v2H6.04L7.7544,4H20.2456l.5715,2H11.7544A2.008,2.008,0,0,0,9.8315,7.45L8.8171,11H7.7144a1.9981,1.9981,0,0,0-1.8916,1.3516L4.5715,16H2v2H4v7a2.0025,2.0025,0,0,0,2,2v3H8V27H20v3h2V27a2.0025,2.0025,0,0,0,2-2V18h2V16H23.4287l-1.251-3.6475A1.9988,1.9988,0,0,0,20.2856,11H10.897l.8574-3ZM22,19v2H20v2h2v2H6V23H8V21H6V19Zm-.3429-2H6.3428l1.3716-4H20.2856Z"></path></svg>`;
export default svgResultCarbonIcon;