/**
 * Copyright IBM Corp. 2024
 *
 * This source code is licensed under the Apache-2.0 license found in the
 * LICENSE file in the root directory of this source tree.
 */

import { svg } from 'lit';
import spread from '../../globals/directives/spread.js';

const svgResultCarbonIcon = ({ children, ...attrs } = {}) => svg`<svg focusable="false" preserveAspectRatio="xMidYMid meet" xmlns="http://www.w3.org/2000/svg" fill="currentColor" ...="${spread(attrs)}" aria-hidden="true" width="16" height="16" viewBox="0 0 32 32">${children}<path stroke-width="0" d="m4.4883,29.8755l23.9868-13.0195c.3438-.1865.5249-.5212.5249-.856,0-.3345-.1812-.6689-.5249-.8555L4.4883,2.125c-.1582-.0862-.3257-.1255-.4883-.125-.5229.0017-1,.4114-1,.9805v26.0393c0,.5691.4771.9788,1,.9802.1626.0005.3301-.0386.4883-.1245Zm.5117-25.1985l20.8677,11.323L5,27.323V4.677Z"></path></svg>`;
export default svgResultCarbonIcon;