/**
 * Copyright IBM Corp. 2024
 *
 * This source code is licensed under the Apache-2.0 license found in the
 * LICENSE file in the root directory of this source tree.
 */

import { svg } from 'lit';
import spread from '../../globals/directives/spread.js';

const svgResultCarbonIcon = ({ children, ...attrs } = {}) => svg`<svg focusable="false" preserveAspectRatio="xMidYMid meet" xmlns="http://www.w3.org/2000/svg" fill="currentColor" ...="${spread(attrs)}" aria-hidden="true" width="20" height="20" viewBox="0 0 32 32">${children}<path d="M30 16L22 24 20.586 22.586 27.172 16 20.586 9.414 22 8 30 16z"></path><path d="M16,22a.9967.9967,0,0,1-.707-.293l-5-5a.9994.9994,0,0,1,0-1.414l5-5a.9994.9994,0,0,1,1.414,0l5,5a.9994.9994,0,0,1,0,1.414l-5,5A.9967.9967,0,0,1,16,22Zm-3.5859-6L16,19.5859,19.5859,16,16,12.4141Z"></path><path d="M2 16L10 8 11.414 9.414 4.828 16 11.414 22.586 10 24 2 16z"></path></svg>`;
export default svgResultCarbonIcon;