/**
 * Copyright IBM Corp. 2024
 *
 * This source code is licensed under the Apache-2.0 license found in the
 * LICENSE file in the root directory of this source tree.
 */

import { svg } from 'lit';
import spread from '../../globals/directives/spread.js';

const svgResultCarbonIcon = ({ children, ...attrs } = {}) => svg`<svg focusable="false" preserveAspectRatio="xMidYMid meet" xmlns="http://www.w3.org/2000/svg" fill="currentColor" ...="${spread(attrs)}" aria-hidden="true" width="16" height="16" viewBox="0 0 32 32">${children}<path d="M4 26H28V28H4zM4 19H28V21H4zM12 6v6H6V6h6m0-2H6A2 2 0 004 6v6a2 2 0 002 2h6a2 2 0 002-2V6a2 2 0 00-2-2zM26 6v6H20V6h6m0-2H20a2 2 0 00-2 2v6a2 2 0 002 2h6a2 2 0 002-2V6a2 2 0 00-2-2z"></path></svg>`;
export default svgResultCarbonIcon;