/**
 * Copyright IBM Corp. 2024
 *
 * This source code is licensed under the Apache-2.0 license found in the
 * LICENSE file in the root directory of this source tree.
 */

import { svg } from 'lit';
import spread from '../../globals/directives/spread.js';

const svgResultCarbonIcon = ({ children, ...attrs } = {}) => svg`<svg focusable="false" preserveAspectRatio="xMidYMid meet" xmlns="http://www.w3.org/2000/svg" fill="currentColor" ...="${spread(attrs)}" aria-hidden="true" width="16" height="16" viewBox="0 0 32 32">${children}<path d="m26,24c-1.1046,0-2,.8954-2,2,0,.0764.0142.1488.0225.2229-2.2808,1.7963-5.0792,2.7771-8.0225,2.7771-7.1685,0-13-5.8315-13-13,0-2.1152.4917-4.1328,1.4619-5.9956l-1.7744-.9238c-1.104,2.1211-1.6875,4.5137-1.6875,6.9194,0,8.271,6.729,15,15,15,3.3744,0,6.5818-1.1193,9.2048-3.1662.244.106.5123.1662.7952.1662,1.1046,0,2-.8954,2-2s-.8954-2-2-2Z"></path><path d="M11 23H13V25H11z" transform="rotate(90 12 24)"></path><path d="M11 9H13V11H11z" transform="rotate(90 12 10)"></path><path d="M11 16H13V18H11z" transform="rotate(90 12 17)"></path><path d="m16,1c-3.3744,0-6.5818,1.1193-9.2048,3.1662-.244-.106-.5123-.1662-.7952-.1662-1.1046,0-2,.8954-2,2s.8954,2,2,2,2-.8954,2-2c0-.0764-.0142-.1488-.0225-.2229,2.2808-1.7963,5.0792-2.7771,8.0225-2.7771,1.6543,0,3,1.3457,3,3s-1.3457,3-3,3h-1v2h1c2.7568,0,5-2.2432,5-5,0-.2399-.0203-.4748-.0531-.7057.9663,1.1348,1.5531,2.6021,1.5531,4.2057,0,3.584-2.916,6.5-6.5,6.5h-1v2h1c4.687,0,8.5-3.813,8.5-8.5,0-.7654-.1111-1.5036-.3017-2.2096,1.1321,1.6206,1.8017,3.587,1.8017,5.7096,0,5.5142-4.4858,10-10,10h-1v2h1c6.6167,0,12-5.3833,12-12,0-.8995-.1058-1.774-.2944-2.6176.8207,1.7031,1.2944,3.6038,1.2944,5.6176,0,2.1152-.4917,4.1328-1.4619,5.9956l1.7744.9238c1.104-2.1211,1.6875-4.5137,1.6875-6.9194C31,7.729,24.271,1,16,1Z"></path></svg>`;
export default svgResultCarbonIcon;