/**
 * Copyright IBM Corp. 2024
 *
 * This source code is licensed under the Apache-2.0 license found in the
 * LICENSE file in the root directory of this source tree.
 */

'use strict';

Object.defineProperty(exports, '__esModule', { value: true });

/**
 * @license
 *
 * Copyright IBM Corp. 2020, 2022, 2023
 *
 * This source code is licensed under the Apache-2.0 license found in the
 * LICENSE file in the root directory of this source tree.
 */
/**
 * Breakpoints for accordion items. It's different from one in `@carbon/layout` library.
 */
exports.ACCORDION_ITEM_BREAKPOINT = void 0;
(function (ACCORDION_ITEM_BREAKPOINT) {
    /**
     * Small breakpoint.
     */
    ACCORDION_ITEM_BREAKPOINT["SMALL"] = "sm";
    /**
     * Medium breakpoint.
     */
    ACCORDION_ITEM_BREAKPOINT["MEDIUM"] = "md";
})(exports.ACCORDION_ITEM_BREAKPOINT || (exports.ACCORDION_ITEM_BREAKPOINT = {}));
/**
 * Accordion size.
 */
exports.ACCORDION_SIZE = void 0;
(function (ACCORDION_SIZE) {
    /**
     * Small size.
     */
    ACCORDION_SIZE["SMALL"] = "sm";
    /**
     * Medium size.
     */
    ACCORDION_SIZE["MEDIUM"] = "md";
    /**
     * Large size.
     */
    ACCORDION_SIZE["LARGE"] = "lg";
})(exports.ACCORDION_SIZE || (exports.ACCORDION_SIZE = {}));
/**
 * Specify the alignment of the accordion heading title and chevron.
 */
exports.ACCORDION_ALIGNMENT = void 0;
(function (ACCORDION_ALIGNMENT) {
    /**
     * Alignment to the start
     */
    ACCORDION_ALIGNMENT["START"] = "start";
    /**
     * Alignment to the end
     */
    ACCORDION_ALIGNMENT["END"] = "END";
})(exports.ACCORDION_ALIGNMENT || (exports.ACCORDION_ALIGNMENT = {}));
//# sourceMappingURL=defs.js.map
