/**
 * Copyright IBM Corp. 2024
 *
 * This source code is licensed under the Apache-2.0 license found in the
 * LICENSE file in the root directory of this source tree.
 */

'use strict';

Object.defineProperty(exports, '__esModule', { value: true });

/**
 * @license
 *
 * Copyright IBM Corp. 2020, 2022, 2023
 *
 * This source code is licensed under the Apache-2.0 license found in the
 * LICENSE file in the root directory of this source tree.
 */
/**
 * Button kind.
 */
exports.BUTTON_KIND = void 0;
(function (BUTTON_KIND) {
    /**
     * Primary button.
     */
    BUTTON_KIND["PRIMARY"] = "primary";
    /**
     * Secondary button.
     */
    BUTTON_KIND["SECONDARY"] = "secondary";
    /**
     * Tertiary button.
     */
    BUTTON_KIND["TERTIARY"] = "tertiary";
    /**
     * Ghost button.
     */
    BUTTON_KIND["GHOST"] = "ghost";
    /**
     * Danger button.
     */
    BUTTON_KIND["DANGER"] = "danger";
    /**
     * @deprecated use 'danger' kind
     * Danger primary button.
     */
    BUTTON_KIND["DANGER_PRIMARY"] = "danger-primary";
    /**
     * Danger tertiary button.
     */
    BUTTON_KIND["DANGER_TERTIARY"] = "danger-tertiary";
    /**
     * Danger ghost button,
     */
    BUTTON_KIND["DANGER_GHOST"] = "danger-ghost";
})(exports.BUTTON_KIND || (exports.BUTTON_KIND = {}));
/**
 * Button type.
 */
exports.BUTTON_TYPE = void 0;
(function (BUTTON_TYPE) {
    /**
     * Default button type.
     */
    BUTTON_TYPE["BUTTON"] = "button";
    /**
     * Reset button type.
     */
    BUTTON_TYPE["RESET"] = "reset";
    /**
     * Submit button type.
     */
    BUTTON_TYPE["SUBMIT"] = "submit";
})(exports.BUTTON_TYPE || (exports.BUTTON_TYPE = {}));
/**
 * Button size.
 */
exports.BUTTON_SIZE = void 0;
(function (BUTTON_SIZE) {
    /**
     * Small size.
     */
    BUTTON_SIZE["SMALL"] = "sm";
    /**
     * Medium size.
     */
    BUTTON_SIZE["MEDIUM"] = "md";
    /**
     * Large size.
     */
    BUTTON_SIZE["LARGE"] = "lg";
    /**
     * X-Large size.
     */
    BUTTON_SIZE["EXTRA_LARGE"] = "xl";
    /**
     * 2X-Large size.
     */
    BUTTON_SIZE["EXTRA_EXTRA_LARGE"] = "2xl";
})(exports.BUTTON_SIZE || (exports.BUTTON_SIZE = {}));
/**
 * Button tooltip alignment.
 */
exports.BUTTON_TOOLTIP_ALIGNMENT = void 0;
(function (BUTTON_TOOLTIP_ALIGNMENT) {
    /**
     * Aligned to the start.
     */
    BUTTON_TOOLTIP_ALIGNMENT["START"] = "left";
    /**
     * Aligned to the center.
     */
    BUTTON_TOOLTIP_ALIGNMENT["CENTER"] = "";
    /**
     * Aligned to the end.
     */
    BUTTON_TOOLTIP_ALIGNMENT["END"] = "right";
})(exports.BUTTON_TOOLTIP_ALIGNMENT || (exports.BUTTON_TOOLTIP_ALIGNMENT = {}));
/**
 * Button tooltip position.
 */
exports.BUTTON_TOOLTIP_POSITION = void 0;
(function (BUTTON_TOOLTIP_POSITION) {
    /**
     * Positioned on the top.
     */
    BUTTON_TOOLTIP_POSITION["TOP"] = "top";
    /**
     * Positioned on the right.
     */
    BUTTON_TOOLTIP_POSITION["RIGHT"] = "right";
    /**
     * Positioned on the bottom.
     */
    BUTTON_TOOLTIP_POSITION["BOTTOM"] = "bottom";
    /**
     * Positined on the left.
     */
    BUTTON_TOOLTIP_POSITION["LEFT"] = "left";
})(exports.BUTTON_TOOLTIP_POSITION || (exports.BUTTON_TOOLTIP_POSITION = {}));
//# sourceMappingURL=defs.js.map
