/**
 * Copyright IBM Corp. 2024
 *
 * This source code is licensed under the Apache-2.0 license found in the
 * LICENSE file in the root directory of this source tree.
 */

'use strict';

Object.defineProperty(exports, '__esModule', { value: true });

/**
 * @license
 *
 * Copyright IBM Corp. 2020, 2023
 *
 * This source code is licensed under the Apache-2.0 license found in the
 * LICENSE file in the root directory of this source tree.
 */
/**
 * Table size.
 */
exports.TABLE_SIZE = void 0;
(function (TABLE_SIZE) {
    /**
     * xs size.
     */
    TABLE_SIZE["XS"] = "xs";
    /**
     * sm size.
     */
    TABLE_SIZE["SM"] = "sm";
    /**
     * md size.
     */
    TABLE_SIZE["MD"] = "md";
    /**
     * lg size - default.
     */
    TABLE_SIZE["LG"] = "lg";
    /**
     * xl size.
     */
    TABLE_SIZE["XL"] = "xl";
})(exports.TABLE_SIZE || (exports.TABLE_SIZE = {}));
/**
 * Table sort state.
 */
exports.TABLE_SORT_DIRECTION = void 0;
(function (TABLE_SORT_DIRECTION) {
    /**
     * Not sorted.
     */
    TABLE_SORT_DIRECTION["NONE"] = "none";
    /**
     * Sorted ascendingly.
     */
    TABLE_SORT_DIRECTION["ASCENDING"] = "ascending";
    /**
     * Sorted descendingly.
     */
    TABLE_SORT_DIRECTION["DESCENDING"] = "descending";
})(exports.TABLE_SORT_DIRECTION || (exports.TABLE_SORT_DIRECTION = {}));
/**
 * Table sort cycle.
 */
exports.TABLE_SORT_CYCLE = void 0;
(function (TABLE_SORT_CYCLE) {
    TABLE_SORT_CYCLE["BI_STATES_FROM_ASCENDING"] = "bi-states-from-ascending";
    TABLE_SORT_CYCLE["BI_STATES_FROM_DESCENDING"] = "bi-states-from-descending";
    TABLE_SORT_CYCLE["TRI_STATES_FROM_ASCENDING"] = "tri-states-from-ascending";
    TABLE_SORT_CYCLE["TRI_STATES_FROM_DESCENDING"] = "tri-states-from-descending";
})(exports.TABLE_SORT_CYCLE || (exports.TABLE_SORT_CYCLE = {}));
/**
 * Mapping of table sort cycles to table sort states.
 */
const TABLE_SORT_CYCLES = {
    [exports.TABLE_SORT_CYCLE.BI_STATES_FROM_ASCENDING]: [
        exports.TABLE_SORT_DIRECTION.ASCENDING,
        exports.TABLE_SORT_DIRECTION.DESCENDING,
    ],
    [exports.TABLE_SORT_CYCLE.BI_STATES_FROM_DESCENDING]: [
        exports.TABLE_SORT_DIRECTION.DESCENDING,
        exports.TABLE_SORT_DIRECTION.ASCENDING,
    ],
    [exports.TABLE_SORT_CYCLE.TRI_STATES_FROM_ASCENDING]: [
        exports.TABLE_SORT_DIRECTION.NONE,
        exports.TABLE_SORT_DIRECTION.ASCENDING,
        exports.TABLE_SORT_DIRECTION.DESCENDING,
    ],
    [exports.TABLE_SORT_CYCLE.TRI_STATES_FROM_DESCENDING]: [
        exports.TABLE_SORT_DIRECTION.NONE,
        exports.TABLE_SORT_DIRECTION.DESCENDING,
        exports.TABLE_SORT_DIRECTION.ASCENDING,
    ],
};

exports.TABLE_SORT_CYCLES = TABLE_SORT_CYCLES;
//# sourceMappingURL=defs.js.map
