/**
 * Copyright IBM Corp. 2024
 *
 * This source code is licensed under the Apache-2.0 license found in the
 * LICENSE file in the root directory of this source tree.
 */

'use strict';

Object.defineProperty(exports, '__esModule', { value: true });

var sharedEnums = require('../../globals/shared-enums.js');

/**
 * @license
 *
 * Copyright IBM Corp. 2020, 2022, 2023
 *
 * This source code is licensed under the Apache-2.0 license found in the
 * LICENSE file in the root directory of this source tree.
 */
/**
 * Navigation direction, associated with key symbols.
 */
const NAVIGATION_DIRECTION = {
    Up: -1,
    ArrowUp: -1,
    Down: 1,
    ArrowDown: 1,
};
/**
 * The keyboard action categories for dropdown.
 */
exports.DROPDOWN_KEYBOARD_ACTION = void 0;
(function (DROPDOWN_KEYBOARD_ACTION) {
    /**
     * Not doing any action.
     */
    DROPDOWN_KEYBOARD_ACTION["NONE"] = "none";
    /**
     * Keyboard action to close menu.
     */
    DROPDOWN_KEYBOARD_ACTION["CLOSING"] = "closing";
    /**
     * Keyboard action to navigate back/forward.
     */
    DROPDOWN_KEYBOARD_ACTION["NAVIGATING"] = "navigating";
    /**
     * Keyboard action to open/close menu on the trigger button or select/deselect a menu item.
     */
    DROPDOWN_KEYBOARD_ACTION["TRIGGERING"] = "triggering";
})(exports.DROPDOWN_KEYBOARD_ACTION || (exports.DROPDOWN_KEYBOARD_ACTION = {}));
/**
 * Dropdown size.
 */
exports.DROPDOWN_SIZE = void 0;
(function (DROPDOWN_SIZE) {
    /**
     * Small size.
     */
    DROPDOWN_SIZE["SMALL"] = "sm";
    /**
     * Medium size.
     */
    DROPDOWN_SIZE["MEDIUM"] = "md";
    /**
     * Large size.
     */
    DROPDOWN_SIZE["LARGE"] = "lg";
})(exports.DROPDOWN_SIZE || (exports.DROPDOWN_SIZE = {}));
/**
 * Dropdown types.
 */
exports.DROPDOWN_TYPE = void 0;
(function (DROPDOWN_TYPE) {
    /**
     * Default type.
     */
    DROPDOWN_TYPE["DEFAULT"] = "";
    /**
     * Inline type.
     */
    DROPDOWN_TYPE["INLINE"] = "inline";
})(exports.DROPDOWN_TYPE || (exports.DROPDOWN_TYPE = {}));
/**
 * Dropdown direction.
 */
exports.DROPDOWN_DIRECTION = void 0;
(function (DROPDOWN_DIRECTION) {
    /**
     * Top.
     */
    DROPDOWN_DIRECTION["TOP"] = "top";
    /**
     * Bottom.
     */
    DROPDOWN_DIRECTION["BOTTOM"] = "bottom";
})(exports.DROPDOWN_DIRECTION || (exports.DROPDOWN_DIRECTION = {}));

Object.defineProperty(exports, 'DROPDOWN_COLOR_SCHEME', {
    enumerable: true,
    get: function () { return sharedEnums.FORM_ELEMENT_COLOR_SCHEME; }
});
exports.NAVIGATION_DIRECTION = NAVIGATION_DIRECTION;
//# sourceMappingURL=defs.js.map
