/**
 * Copyright IBM Corp. 2024
 *
 * This source code is licensed under the Apache-2.0 license found in the
 * LICENSE file in the root directory of this source tree.
 */

'use strict';

Object.defineProperty(exports, '__esModule', { value: true });

/**
 * @license
 *
 * Copyright IBM Corp. 2020, 2022, 2023
 *
 * This source code is licensed under the Apache-2.0 license found in the
 * LICENSE file in the root directory of this source tree.
 */
/**
 * The LTR/RTL direction used for positioning floating menu.
 */
exports.FLOATING_MENU_POSITION_DIRECTION = void 0;
(function (FLOATING_MENU_POSITION_DIRECTION) {
    /**
     * LTR.
     */
    FLOATING_MENU_POSITION_DIRECTION["LTR"] = "ltr";
    /**
     * RTL.
     */
    FLOATING_MENU_POSITION_DIRECTION["RTL"] = "rtl";
})(exports.FLOATING_MENU_POSITION_DIRECTION || (exports.FLOATING_MENU_POSITION_DIRECTION = {}));
/**
 * The direction/positioning/orientation choices of floating menu.
 */
exports.FLOATING_MENU_DIRECTION = void 0;
(function (FLOATING_MENU_DIRECTION) {
    /**
     * Put menu body at the top of its trigger button.
     */
    FLOATING_MENU_DIRECTION["TOP"] = "top";
    /**
     * Put menu body at the bottom of its trigger button.
     */
    FLOATING_MENU_DIRECTION["BOTTOM"] = "bottom";
})(exports.FLOATING_MENU_DIRECTION || (exports.FLOATING_MENU_DIRECTION = {}));
//# sourceMappingURL=defs.js.map
