/**
 * Copyright IBM Corp. 2024
 *
 * This source code is licensed under the Apache-2.0 license found in the
 * LICENSE file in the root directory of this source tree.
 */

'use strict';

Object.defineProperty(exports, '__esModule', { value: true });

/**
 * @license
 *
 * Copyright IBM Corp. 2023
 *
 * This source code is licensed under the Apache-2.0 license found in the
 * LICENSE file in the root directory of this source tree.
 */
/**
 * Status of progress bar.
 */
exports.PROGRESS_BAR_STATUS = void 0;
(function (PROGRESS_BAR_STATUS) {
    /**
     * Currently active.
     */
    PROGRESS_BAR_STATUS["ACTIVE"] = "active";
    /**
     * Executed.
     */
    PROGRESS_BAR_STATUS["FINISHED"] = "finished";
    /**
     * Invalid.
     */
    PROGRESS_BAR_STATUS["ERROR"] = "error";
})(exports.PROGRESS_BAR_STATUS || (exports.PROGRESS_BAR_STATUS = {}));
/**
 * Size of progress bar.
 */
exports.PROGRESS_BAR_SIZE = void 0;
(function (PROGRESS_BAR_SIZE) {
    /**
     * small size (thinner)
     */
    PROGRESS_BAR_SIZE["SMALL"] = "small";
    /**
     * big size
     */
    PROGRESS_BAR_SIZE["BIG"] = "big";
})(exports.PROGRESS_BAR_SIZE || (exports.PROGRESS_BAR_SIZE = {}));
/**
 * Defines the alignment variant of the progress bar.
 */
exports.PROGRESS_BAR_TYPE = void 0;
(function (PROGRESS_BAR_TYPE) {
    /**
     * default type
     */
    PROGRESS_BAR_TYPE["DEFAULT"] = "default";
    /**
     * Inline type
     */
    PROGRESS_BAR_TYPE["INLINE"] = "inline";
    /**
     * indented type
     */
    PROGRESS_BAR_TYPE["INDENTED"] = "indented";
})(exports.PROGRESS_BAR_TYPE || (exports.PROGRESS_BAR_TYPE = {}));
//# sourceMappingURL=defs.js.map
