/**
 * @license
 *
 * Copyright IBM Corp. 2019, 2024
 *
 * This source code is licensed under the Apache-2.0 license found in the
 * LICENSE file in the root directory of this source tree.
 */
import { LitElement, TemplateResult } from 'lit';
import { SKELETON_TEXT_TYPE } from './defs';
export { SKELETON_TEXT_TYPE };
/**
 * Skeleton text.
 *
 * @element cds-skeleton-text
 */
declare class CDSSkeletonText extends LitElement {
    /**
     * Specify optional classes to be added to your SkeletonText
     */
    optionalClasses: any;
    /**
     * The type of skeleton text.
     */
    type: SKELETON_TEXT_TYPE;
    /**
     * width (in px or %) of single line of text or max-width of paragraph lines
     */
    width: string;
    /**
     * will generate multiple lines of text
     */
    paragraph: boolean;
    /**
     * the number of lines in a paragraph
     */
    lineCount: number;
    render(): TemplateResult<1> | TemplateResult<1 | 2>[];
    static styles: any;
}
export default CDSSkeletonText;
