/**
 * Copyright IBM Corp. 2024
 *
 * This source code is licensed under the Apache-2.0 license found in the
 * LICENSE file in the root directory of this source tree.
 */

'use strict';

Object.defineProperty(exports, '__esModule', { value: true });

/**
 * @license
 *
 * Copyright IBM Corp. 2020, 2023
 *
 * This source code is licensed under the Apache-2.0 license found in the
 * LICENSE file in the root directory of this source tree.
 */
/**
 * The keyboard action categories for dropdown.
 */
exports.TABS_KEYBOARD_ACTION = void 0;
(function (TABS_KEYBOARD_ACTION) {
    /**
     * Not doing any action.
     */
    TABS_KEYBOARD_ACTION["NONE"] = "none";
    /**
     * Keyboard action to navigate back/forward.
     */
    TABS_KEYBOARD_ACTION["NAVIGATING"] = "navigating";
    /**
     * Keyboard action to navigate to first tab using home key
     */
    TABS_KEYBOARD_ACTION["HOME"] = "home";
    /**
     * Keyboard action to navigate to last tab using end key
     */
    TABS_KEYBOARD_ACTION["END"] = "end";
})(exports.TABS_KEYBOARD_ACTION || (exports.TABS_KEYBOARD_ACTION = {}));
/**
 * Tabs types.
 */
exports.TABS_TYPE = void 0;
(function (TABS_TYPE) {
    /**
     * Regular tabs.
     */
    TABS_TYPE["REGULAR"] = "";
    /**
     * Container type.
     */
    TABS_TYPE["CONTAINER"] = "container";
    /**
     * Contained type.
     */
    TABS_TYPE["CONTAINED"] = "contained";
})(exports.TABS_TYPE || (exports.TABS_TYPE = {}));
//# sourceMappingURL=defs.js.map
