/**
 * Copyright IBM Corp. 2024
 *
 * This source code is licensed under the Apache-2.0 license found in the
 * LICENSE file in the root directory of this source tree.
 */

'use strict';

Object.defineProperty(exports, '__esModule', { value: true });

/**
 * @license
 *
 * Copyright IBM Corp. 2020
 *
 * This source code is licensed under the Apache-2.0 license found in the
 * LICENSE file in the root directory of this source tree.
 */
/**
 * Collapse modes of side nav.
 */
exports.SIDE_NAV_COLLAPSE_MODE = void 0;
(function (SIDE_NAV_COLLAPSE_MODE) {
    /**
     * Fixed mode.
     * In this mode, side nav is non-collapsible.
     */
    SIDE_NAV_COLLAPSE_MODE["FIXED"] = "fixed";
    /**
     * Rail mode.
     * In this mode, side nav can be collapsed to a narrower width ("rail" look) with a toggle button.
     */
    SIDE_NAV_COLLAPSE_MODE["RAIL"] = "rail";
    /**
     * Responsive mode.
     * In this mode, side nav sticks in wider screen, and can be completely collapsed with a toggle button in narrower screen.
     */
    SIDE_NAV_COLLAPSE_MODE["RESPONSIVE"] = "responsive";
})(exports.SIDE_NAV_COLLAPSE_MODE || (exports.SIDE_NAV_COLLAPSE_MODE = {}));
/**
 * The usage purpose of side nav.
 */
exports.SIDE_NAV_USAGE_MODE = void 0;
(function (SIDE_NAV_USAGE_MODE) {
    /**
     * Regular usage.
     */
    SIDE_NAV_USAGE_MODE["REGULAR"] = "";
    /**
     * To represent header nav.
     * In this mode, side nav is hidden when header nav is shown, and side nav is shown then header nav is hidden.
     * This mode can be used only with `SIDE_NAV_COLLAPSE_MODE.REGULAR`.
     */
    SIDE_NAV_USAGE_MODE["HEADER_NAV"] = "header-nav";
})(exports.SIDE_NAV_USAGE_MODE || (exports.SIDE_NAV_USAGE_MODE = {}));
//# sourceMappingURL=defs.js.map
