/**
 * Copyright IBM Corp. 2024
 *
 * This source code is licensed under the Apache-2.0 license found in the
 * LICENSE file in the root directory of this source tree.
 */

'use strict';

Object.defineProperty(exports, '__esModule', { value: true });

var dom = require('@floating-ui/dom');

/**
 * @license
 *
 * Copyright IBM Corp. 2024
 *
 * This source code is licensed under the Apache-2.0 license found in the
 * LICENSE file in the root directory of this source tree.
 */
class PopoverController {
    /**
     * register with host component
     * @param host host component
     */
    constructor(host) {
        this.updatePlacement = () => {
            this.computePlacement();
        };
        (this.host = host).addController(this);
    }
    async setPlacement(options = this.options) {
        this.options = options;
        const { trigger, target } = options;
        this.cleanup = dom.autoUpdate(trigger, target, this.updatePlacement);
    }
    async computePlacement() {
        var _a;
        const { arrowElement, alignment, caret, trigger, target } = this.options;
        let shimmedAlign;
        switch (alignment) {
            case 'top-left':
                shimmedAlign = 'top-start';
                break;
            case 'top-right':
                shimmedAlign = 'top-end';
                break;
            case 'bottom-left':
                shimmedAlign = 'bottom-start';
                break;
            case 'bottom-right':
                shimmedAlign = 'bottom-end';
                break;
            case 'left-bottom':
                shimmedAlign = 'left-end';
                break;
            case 'left-top':
                shimmedAlign = 'left-start';
                break;
            case 'right-bottom':
                shimmedAlign = 'right-end';
                break;
            case 'right-top':
                shimmedAlign = 'right-start';
                break;
            default:
                shimmedAlign = alignment;
                break;
        }
        const middleware = [
            dom.flip({ fallbackAxisSideDirection: 'start' }),
            dom.offset(caret ? 10 : 0),
            ...(caret && arrowElement
                ? [dom.arrow({ element: arrowElement, padding: 15 })]
                : []),
        ];
        if (this.host.hasAttribute('open')) {
            const { x, y, placement, middlewareData, strategy } = await dom.computePosition(trigger, target, {
                strategy: 'fixed',
                middleware,
                placement: shimmedAlign,
            });
            target.style.left = `${x}px`;
            target.style.top = `${y}px`;
            target.style.position = `${strategy}`;
            if (arrowElement) {
                // @ts-ignore
                const { x: arrowX, y: arrowY } = middlewareData.arrow;
                const staticSide = {
                    top: 'bottom',
                    right: 'left',
                    bottom: 'top',
                    left: 'right',
                }[placement.split('-')[0]];
                arrowElement.style.left = arrowX != null ? `${arrowX}px` : '';
                arrowElement.style.top = arrowY != null ? `${arrowY}px` : '';
                arrowElement.style.right = '';
                arrowElement.style.bottom = '';
                arrowElement.style[staticSide] = `${-arrowElement.offsetWidth / 2}px`;
            }
            // adding specific case here where the style of the caret/arrow
            // is dependent on the placement
            // TODO: remove reference to slug in v12
            if (this.host.tagName === 'CDS-AI-LABEL' ||
                this.host.tagName === 'CDS-SLUG') {
                (_a = this.host) === null || _a === void 0 ? void 0 : _a.setAttribute('alignment', placement);
            }
        }
    }
    hostUpdated() {
        var _a;
        if (!this.host.hasAttribute('open')) {
            (_a = this.cleanup) === null || _a === void 0 ? void 0 : _a.call(this);
            this.cleanup = undefined;
        }
    }
    hostDisconnected() {
        var _a;
        (_a = this.cleanup) === null || _a === void 0 ? void 0 : _a.call(this);
        this.cleanup = undefined;
    }
}

exports["default"] = PopoverController;
//# sourceMappingURL=popover-controller.js.map
