/**
 * Type definition for CertLogic expressions.
 */
export declare type CertLogicExpression = CertLogicExpression[] | {
    "var": string;
} | {
    "and": CertLogicExpression[];
} | {
    "if": [CertLogicExpression, CertLogicExpression, CertLogicExpression];
} | {
    "===": [CertLogicExpression, CertLogicExpression];
} | {
    "<": [CertLogicExpression, CertLogicExpression] | [CertLogicExpression, CertLogicExpression, CertLogicExpression];
} | {
    ">": [CertLogicExpression, CertLogicExpression] | [CertLogicExpression, CertLogicExpression, CertLogicExpression];
} | {
    "<=": [CertLogicExpression, CertLogicExpression] | [CertLogicExpression, CertLogicExpression, CertLogicExpression];
} | {
    ">=": [CertLogicExpression, CertLogicExpression] | [CertLogicExpression, CertLogicExpression, CertLogicExpression];
} | {
    "in": [CertLogicExpression, CertLogicExpression];
} | {
    "+": [CertLogicExpression, CertLogicExpression];
} | {
    "!": [CertLogicExpression];
} | {
    "plusTime": [CertLogicExpression, number, TimeUnit];
} | {
    "reduce": [CertLogicExpression, CertLogicExpression, CertLogicExpression];
} | boolean | number | string;
export declare type TimeUnit = "year" | "month" | "day" | "hour";
export declare const timeUnits: TimeUnit[];
//# sourceMappingURL=typings.d.ts.map