"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.dataAccesses = void 0;
const gatherFrom = (expr) => {
    if (Array.isArray(expr)) {
        return expr.flatMap(gatherFrom);
    }
    if (typeof expr === "object") {
        const keys = Object.keys(expr);
        const operator = keys[0];
        const values = expr[operator];
        if (operator === "var") {
            return [values];
        }
        if (operator === "if") {
            const [guard, then, else_] = values;
            return [...gatherFrom(guard), ...gatherFrom(then), ...gatherFrom(else_)];
        }
        if (["===", "and", ">", "<", ">=", "<=", "in", "+", "after", "before", "not-after", "not-before"].indexOf(operator) > -1) {
            return values.flatMap(gatherFrom);
        }
        if (operator === "!") {
            return gatherFrom(values[0]);
        }
        if (operator === "plusTime") {
            return gatherFrom(values[0]);
        }
        if (operator === "reduce") {
            return [/* operand: */ ...gatherFrom(values[0]), /* initial: */ ...gatherFrom(values[2])];
        }
        throw new Error(`operator not recognised by fields gatherer ("gatherFields") in certlogic-js/validation/${__filename}: "${operator}"`);
    }
    return [];
};
/**
 * Compute which data accesses can be performed by the given CertLogic expression.
 * @param expr A CertLogic expression.
 */
const dataAccesses = (expr) => [...new Set(gatherFrom(expr))].sort();
exports.dataAccesses = dataAccesses;
//# sourceMappingURL=data-accesses.js.map