/* cfb.js (C) 2013-2014 SheetJS -- http://sheetjs.com */
var Base64=function(){var map="ABCDEFGHIJKLMNOPQRSTUVWXYZabcdefghijklmnopqrstuvwxyz0123456789+/=";return{decode:function(input,utf8){var o="";var c1,c2,c3;var e1,e2,e3,e4;input=input.replace(/[^A-Za-z0-9\+\/\=]/g,"");for(var i=0;i<input.length;){e1=map.indexOf(input.charAt(i++));e2=map.indexOf(input.charAt(i++));e3=map.indexOf(input.charAt(i++));e4=map.indexOf(input.charAt(i++));c1=e1<<2|e2>>4;c2=(e2&15)<<4|e3>>2;c3=(e3&3)<<6|e4;o+=String.fromCharCode(c1);if(e3!=64){o+=String.fromCharCode(c2)}if(e4!=64){o+=String.fromCharCode(c3)}}return o}}}();function s2a(s){if(typeof Buffer!=="undefined")return new Buffer(s,"binary");var w=s.split("").map(function(x){return x.charCodeAt(0)&255});return w}var __toBuffer;if(typeof Buffer!=="undefined"){Buffer.prototype.hexlify=function(){return this.toString("hex")};Buffer.prototype.utf16le=function(s,e){return this.toString("utf16le",s,e).replace(/\u0000/,"").replace(/[\u0001-\u0006]/,"!")};Buffer.prototype.utf8=function(s,e){return this.toString("utf8",s,e)};__toBuffer=function(bufs){return Buffer.concat(bufs[0])}}else{__toBuffer=function(bufs){var x=[];for(var i=0;i!=bufs[0].length;++i){x=x.concat(bufs[0][i])}return x}}var __readUInt8=function(b,idx){return b.readUInt8?b.readUInt8(idx):b[idx]};var __readUInt16LE=function(b,idx){return b.readUInt16LE?b.readUInt16LE(idx):b[idx+1]*(1<<8)+b[idx]};var __readInt16LE=function(b,idx){var u=__readUInt16LE(b,idx);if(!(u&32768))return u;return(65535-u+1)*-1};var __readUInt32LE=function(b,idx){return b.readUInt32LE?b.readUInt32LE(idx):b[idx+3]*(1<<24)+b[idx+2]*(1<<16)+b[idx+1]*(1<<8)+b[idx]};var __readInt32LE=function(b,idx){if(b.readInt32LE)return b.readInt32LE(idx);var u=__readUInt32LE(b,idx);if(!(u&2147483648))return u;return(4294967295-u+1)*-1};var __hexlify=function(b){return b.map(function(x){return(x<16?"0":"")+x.toString(16)}).join("")};var __utf16le=function(b,s,e){if(b.utf16le)return b.utf16le(s,e);var ss=[];for(var i=s;i<e;i+=2)ss.push(String.fromCharCode(__readUInt16LE(b,i)));return ss.join("").replace(/\u0000/,"").replace(/[\u0001-\u0006]/,"!")};var __utf8=function(b,s,e){if(b.utf8)return b.utf8(s,e);var ss=[];for(var i=s;i<e;i++)ss.push(String.fromCharCode(__readUInt8(b,i)));return ss.join("")};function bconcat(bufs){return typeof Buffer!=="undefined"?Buffer.concat(bufs):[].concat.apply([],bufs)}function ReadShift(size,t){var o,oo=[],w,vv;t=t||"u";switch(size){case 1:o=__readUInt8(this,this.l);break;case 2:o=(t==="u"?__readUInt16LE:__readInt16LE)(this,this.l);break;case 4:o=__readUInt32LE(this,this.l);break;case 8:case 16:o=this.toString("hex",this.l,this.l+size);break;case"utf8":size=t;o=__utf8(this,this.l,this.l+size);break;case"utf16le":size=2*t;o=__utf16le(this,this.l,this.l+size);break;case"cstr":size=0;o="";while((w=__readUInt8(this,this.l+size++))!==0)oo.push(String.fromCharCode(w));o=oo.join("");break;case"wstr":size=0;o="";while((w=__readUInt16LE(this,this.l+size))!==0){oo.push(String.fromCharCode(w));size+=2}size+=2;break}this.l+=size;return o}function CheckField(hexstr,fld){var b=this.slice(this.l,this.l+hexstr.length/2);var m=b.hexlify?b.hexlify():__hexlify(b);if(m!==hexstr)throw(fld||"")+"Expected "+hexstr+" saw "+m;this.l+=hexstr.length/2}function prep_blob(blob,pos){blob.read_shift=ReadShift.bind(blob);blob.chk=CheckField;blob.l=pos||0;var read=ReadShift.bind(blob),chk=CheckField.bind(blob);return[read,chk]}var CFB=function(){this.version="0.9.1";function parse(file){var mver=3;var ssz=512;var mssz=64;var nds=0;var nfs=0;var nmfs=0;var ndfs=0;var dir_start=0;var minifat_start=0;var difat_start=0;var ms_cutoff_size=4096;var minifat_store=0;var minifat_size=0;var fat_addrs=[];var blob=file.slice(0,512);prep_blob(blob);var read=ReadShift.bind(blob),chk=CheckField.bind(blob);var j=0,q;chk(HEADER_SIGNATURE,"Header Signature: ");chk(HEADER_CLSID,"CLSID: ");read(2);mver=read(2);switch(mver){case 3:ssz=512;break;case 4:ssz=4096;break;default:throw"Major Version: Expected 3 or 4 saw "+mver}var pos=blob.l;blob=file.slice(0,ssz);prep_blob(blob,pos);read=ReadShift.bind(blob);chk=CheckField.bind(blob);var header=file.slice(0,ssz);chk("feff","Byte Order: ");switch(q=read(2)){case 9:if(mver!==3)throw"MajorVersion/SectorShift Mismatch";break;case 12:if(mver!==4)throw"MajorVersion/SectorShift Mismatch";break;default:throw"Sector Shift: Expected 9 or 12 saw "+q}chk("0600","Mini Sector Shift: ");chk("000000000000","Mini Sector Shift: ");nds=read(4);if(mver===3&&nds!==0)throw"# Directory Sectors: Expected 0 saw "+nds;nfs=read(4);dir_start=read(4);read(4);chk("00100000","Mini Stream Cutoff Size: ");minifat_start=read(4);nmfs=read(4);difat_start=read(4);ndfs=read(4);for(j=0;blob.l!=512;){if((q=read(4))>=MAXREGSECT)break;fat_addrs[j++]=q}var nsectors=Math.ceil((file.length-ssz)/ssz);var sectors=[];for(var i=1;i!=nsectors;++i)sectors[i-1]=file.slice(i*ssz,(i+1)*ssz);sectors[nsectors-1]=file.slice(nsectors*ssz);function sleuth_fat(idx,cnt){if(idx===ENDOFCHAIN){if(cnt!==0)throw"DIFAT chain shorter than expected";return}if(idx!==FREESECT){var sector=sectors[idx];for(var i=0;i!=ssz/4-1;++i){if((q=__readUInt32LE(sector,i*4))===ENDOFCHAIN)break;fat_addrs.push(q)}sleuth_fat(__readUInt32LE(sector,ssz-4),cnt-1)}}sleuth_fat(difat_start,ndfs);function get_buffer(byte_addr,bytes){var addr=fat_addrs[Math.floor(byte_addr*4/ssz)];if(ssz-byte_addr*4%ssz<(bytes||0))throw"FAT boundary crossed: "+byte_addr+" "+bytes+" "+ssz;return sectors[addr].slice(byte_addr*4%ssz)}function get_buffer_u32(byte_addr){return __readUInt32LE(get_buffer(byte_addr,4),0)}function get_next_sector(idx){return get_buffer_u32(idx)}var chkd=new Array(sectors.length),sector_list=[];var get_sector=function get_sector(k){return sectors[k]};for(i=0;i!=sectors.length;++i){var buf=[],k=(i+dir_start)%sectors.length;if(chkd[k])continue;for(j=k;j<=MAXREGSECT;buf.push(j),j=get_next_sector(j))chkd[j]=true;sector_list[k]={nodes:buf};sector_list[k].data=__toBuffer(Array(buf.map(get_sector)))}sector_list[dir_start].name="!Directory";if(nmfs>0&&minifat_start!==ENDOFCHAIN)sector_list[minifat_start].name="!MiniFAT";sector_list[fat_addrs[0]].name="!FAT";var files={},Paths=[],FileIndex=[],FullPaths=[],FullPathDir={};function read_directory(idx){var blob,read,w;var sector=sector_list[idx].data;for(var i=0;i!=sector.length;i+=128){blob=sector.slice(i,i+128);prep_blob(blob,64);read=ReadShift.bind(blob);var namelen=read(2);if(namelen===0)return;var name=__utf16le(blob,0,namelen-(Paths.length?2:0));Paths.push(name);var o={name:name};o.type=EntryTypes[read(1)];o.color=read(1);o.left=read(4);if(o.left===NOSTREAM)delete o.left;o.right=read(4);if(o.right===NOSTREAM)delete o.right;o.child=read(4);if(o.child===NOSTREAM)delete o.child;o.clsid=read(16);o.state=read(4);var ctime=read(8);if(ctime!="0000000000000000")o.ctime=ctime;var mtime=read(8);if(mtime!="0000000000000000")o.mtime=mtime;o.start=read(4);o.size=read(4);if(o.type==="root"){minifat_store=o.start;if(nmfs>0&&minifat_store!==ENDOFCHAIN)sector_list[minifat_store].name="!StreamData";minifat_size=o.size}else if(o.size>=ms_cutoff_size){o.storage="fat";if(!sector_list[o.start]&&dir_start>0)o.start=(o.start+dir_start)%sectors.length;sector_list[o.start].name=o.name;o.content=sector_list[o.start].data.slice(0,o.size);prep_blob(o.content)}else{o.storage="minifat";w=o.start*mssz;if(minifat_store!==ENDOFCHAIN&&o.start!==ENDOFCHAIN){o.content=sector_list[minifat_store].data.slice(w,w+o.size);prep_blob(o.content)}}if(o.ctime){var ct=blob.slice(blob.l-24,blob.l-16);var c2=__readUInt32LE(ct,4)/1e7*Math.pow(2,32)+__readUInt32LE(ct,0)/1e7;o.ct=new Date((c2-11644473600)*1e3)}if(o.mtime){var mt=blob.slice(blob.l-16,blob.l-8);var m2=__readUInt32LE(mt,4)/1e7*Math.pow(2,32)+__readUInt32LE(mt,0)/1e7;o.mt=new Date((m2-11644473600)*1e3)}files[name]=o;FileIndex.push(o)}}read_directory(dir_start);function build_full_paths(Dir,pathobj,paths,patharr){var i;var dad=new Array(patharr.length);var q=new Array(patharr.length);for(i=0;i!=dad.length;++i){dad[i]=q[i]=i;paths[i]=patharr[i]}while(q.length>0){for(i=q[0];typeof i!=="undefined";i=q.shift()){if(dad[i]===i){if(Dir[i].left&&dad[Dir[i].left]!=Dir[i].left)dad[i]=dad[Dir[i].left];if(Dir[i].right&&dad[Dir[i].right]!=Dir[i].right)dad[i]=dad[Dir[i].right]}if(Dir[i].child)dad[Dir[i].child]=i;if(Dir[i].left){dad[Dir[i].left]=dad[i];q.push(Dir[i].left)}if(Dir[i].right){dad[Dir[i].right]=dad[i];q.push(Dir[i].right)}}for(i=1;i!=dad.length;++i)if(dad[i]===i){if(Dir[i].right&&dad[Dir[i].right]!=Dir[i].right)dad[i]=dad[Dir[i].right];else if(Dir[i].left&&dad[Dir[i].left]!=Dir[i].left)dad[i]=dad[Dir[i].left]}}for(i=1;i!==paths.length;++i){if(Dir[i].type==="unknown")continue;var j=dad[i];if(j===0)paths[i]=paths[0]+"/"+paths[i];else while(j!==0){paths[i]=paths[j]+"/"+paths[i];j=dad[j]}dad[i]=0}paths[0]+="/";for(i=1;i!==paths.length;++i)if(Dir[i].type!=="stream")paths[i]+="/";for(i=0;i!==paths.length;++i)pathobj[paths[i]]=FileIndex[i]}build_full_paths(FileIndex,FullPathDir,FullPaths,Paths);var root_name=Paths.shift();Paths.root=root_name;function find_path(path){if(path[0]==="/")path=root_name+path;var UCNames=(path.indexOf("/")!==-1?FullPaths:Paths).map(function(x){return x.toUpperCase()});var UCPath=path.toUpperCase();var w=UCNames.indexOf(UCPath);if(w===-1)return null;return path.indexOf("/")!==-1?FileIndex[w]:files[Paths[w]]}var rval={raw:{header:header,sectors:sectors},FileIndex:FileIndex,FullPaths:FullPaths,FullPathDir:FullPathDir,find:find_path};return rval}function readFileSync(filename){var fs=require("fs");var file=fs.readFileSync(filename);return parse(file)}function readSync(blob,options){var o=options||{};switch(o.type||"base64"){case"file":return readFileSync(blob);case"base64":blob=Base64.decode(blob);case"binary":blob=s2a(blob);break}return parse(blob)}this.read=readSync;this.parse=parse;return this}();{var MAXREGSECT=4294967290;var DIFSECT=4294967292;var FATSECT=4294967293;var ENDOFCHAIN=4294967294;var FREESECT=4294967295;var HEADER_SIGNATURE="d0cf11e0a1b11ae1";var HEADER_MINOR_VERSION="3e00";var MAXREGSID=4294967290;var NOSTREAM=4294967295;var HEADER_CLSID="00000000000000000000000000000000";var EntryTypes=["unknown","storage","stream","lockbytes","property","root"]}var CFB_utils={ReadShift:ReadShift,CheckField:CheckField,prep_blob:prep_blob,bconcat:bconcat};if(typeof require!=="undefined"&&typeof exports!=="undefined"){var fs=require("fs");exports.read=CFB.read;exports.parse=CFB.parse;exports.utils=CFB_utils;exports.version=CFB.version}
//# sourceMappingURL=dist/cfb.min.map