var _timestack = (() => {
  var __create = Object.create;
  var __defProp = Object.defineProperty;
  var __getOwnPropDesc = Object.getOwnPropertyDescriptor;
  var __getOwnPropNames = Object.getOwnPropertyNames;
  var __getProtoOf = Object.getPrototypeOf;
  var __hasOwnProp = Object.prototype.hasOwnProperty;
  var __commonJS = (cb, mod) => function __require() {
    return mod || (0, cb[__getOwnPropNames(cb)[0]])((mod = { exports: {} }).exports, mod), mod.exports;
  };
  var __export = (target, all) => {
    for (var name in all)
      __defProp(target, name, { get: all[name], enumerable: true });
  };
  var __copyProps = (to, from, except, desc) => {
    if (from && typeof from === "object" || typeof from === "function") {
      for (let key of __getOwnPropNames(from))
        if (!__hasOwnProp.call(to, key) && key !== except)
          __defProp(to, key, { get: () => from[key], enumerable: !(desc = __getOwnPropDesc(from, key)) || desc.enumerable });
    }
    return to;
  };
  var __toESM = (mod, isNodeMode, target) => (target = mod != null ? __create(__getProtoOf(mod)) : {}, __copyProps(
    // If the importer is in node compatibility mode or this is not an ESM
    // file that has been converted to a CommonJS file using a Babel-
    // compatible transform (i.e. "__esModule" has not been set), then set
    // "default" to the CommonJS "module.exports" for node compatibility.
    isNodeMode || !mod || !mod.__esModule ? __defProp(target, "default", { value: mod, enumerable: true }) : target,
    mod
  ));
  var __toCommonJS = (mod) => __copyProps(__defProp({}, "__esModule", { value: true }), mod);

  // globals:chart.js
  var require_chart = __commonJS({
    "globals:chart.js"(exports, module) {
      module.exports = Chart;
    }
  });

  // globals:luxon
  var require_luxon = __commonJS({
    "globals:luxon"(exports, module) {
      module.exports = luxon;
    }
  });

  // src/index.ts
  var src_exports = {};
  __export(src_exports, {
    DEF_TICK_GENERATORS: () => DEF_TICK_GENERATORS,
    DEF_TOOLTIP_FORMAT: () => DEF_TOOLTIP_FORMAT,
    DaysTickGenerator: () => DaysTickGenerator,
    HM: () => HM,
    HMS: () => HMS,
    MD: () => MD,
    MDAY: () => MDAY,
    MON: () => MON,
    TickGenerator: () => TickGenerator,
    TimestackScale: () => TimestackScale,
    YEAR: () => YEAR,
    YM: () => YM,
    YMD: () => YMD,
    YearsTickGenerator: () => YearsTickGenerator
  });
  var import_chart2 = __toESM(require_chart());

  // src/scale.ts
  var import_chart = __toESM(require_chart());
  var import_luxon3 = __toESM(require_luxon());

  // src/ticks.ts
  var import_luxon2 = __toESM(require_luxon());

  // src/measure.ts
  var import_luxon = __toESM(require_luxon());
  var _widest_dates_cache = /* @__PURE__ */ new Map();
  var _widest_labels_cache = /* @__PURE__ */ new Map();
  function _pick_widest_sample(ctx, samples, format) {
    let longest = [{}, 0];
    for (const dt of samples) {
      if (!dt.isValid)
        throw "invalid datetime";
      const text = dt.toLocaleString(format);
      const width = ctx.measureText(text).width;
      if (width > longest[1])
        longest = [dt, width, text];
    }
    return longest[0];
  }
  function find_widest_local_date(key, format, ctx, opts) {
    const id = `${format.month}/${format.weekday}`;
    const cached = _widest_dates_cache.get(key);
    if (cached)
      return cached[id];
    const widest_numeric_date = { year: 2024, month: 12, day: 22, hour: 23, minute: 59, second: 59 };
    const num = import_luxon.DateTime.fromObject(widest_numeric_date, opts);
    function* months_candidates(base) {
      for (let i = 1; i <= 12; i++)
        yield base.set({ month: i });
    }
    const sm = _pick_widest_sample(ctx, months_candidates(num), { month: "short" });
    const lm = _pick_widest_sample(ctx, months_candidates(num), { month: "long" });
    function* weekdays_candidates(base) {
      for (let i = 22; i < 29; i++)
        yield base.set({ day: i });
    }
    const sm_sw = _pick_widest_sample(ctx, weekdays_candidates(sm), { weekday: "short" });
    const sm_lw = _pick_widest_sample(ctx, weekdays_candidates(sm), { weekday: "long" });
    const sm_nw = _pick_widest_sample(ctx, weekdays_candidates(sm), { weekday: "narrow" });
    const lm_sw = _pick_widest_sample(ctx, weekdays_candidates(lm), { weekday: "short" });
    const lm_lw = _pick_widest_sample(ctx, weekdays_candidates(lm), { weekday: "long" });
    const lm_nw = _pick_widest_sample(ctx, weekdays_candidates(lm), { weekday: "narrow" });
    const perms = {
      "undefined/undefined": num,
      "undefined/short": sm_sw,
      "undefined/long": sm_lw,
      "undefined/narrow": sm_nw,
      "numeric/undefined": num,
      "numeric/short": sm_sw,
      "numeric/long": sm_lw,
      "numeric/narrow": sm_nw,
      "2-digit/undefined": num,
      "2-digit/short": sm_sw,
      "2-digit/long": sm_lw,
      "2-digit/narrow": sm_nw,
      "short/undefined": sm,
      "short/short": sm_sw,
      "short/long": sm_lw,
      "short/narrow": sm_nw,
      "long/undefined": lm,
      "long/short": lm_sw,
      "long/long": lm_lw,
      "long/narrow": lm_nw
    };
    const result = Object.fromEntries(Object.entries(perms).map(([k, v]) => [k, v.toObject()]));
    _widest_dates_cache.set(key, result);
    return result[id];
  }
  function measure_max_label_width(format, ctx, opts) {
    const format_key = JSON.stringify(format);
    const dt_key = `${opts.locale || import_luxon.Settings.defaultLocale}/${ctx.font}`;
    const label_key = `${dt_key}/${format_key}`;
    const cached = _widest_labels_cache.get(label_key);
    if (cached)
      return cached;
    const widest_date = find_widest_local_date(dt_key, format, ctx, opts);
    const dt = import_luxon.DateTime.fromObject(widest_date, opts);
    const label = dt.toLocaleString(format);
    const res = ctx.measureText(label).width;
    _widest_labels_cache.set(label_key, res);
    return res;
  }

  // src/ticks.ts
  var TickGenerator = class {
    /** Generator yielding (possibly infinite) sequence of _SeqTick-s. It's ok to return the ticks
     * before the 'from'
     */
    *seq(from) {
    }
    constructor(top, bottom) {
      this.top = top;
      this.bottom = bottom;
    }
    estimate(range, ctx, opts, may_be_long = true) {
      const top = this.top;
      const bottom = this.bottom;
      const normal = measure_max_label_width(top.fmt, ctx, opts);
      const major = top.maj_fmt ? measure_max_label_width(top.maj_fmt, ctx, opts) : 0;
      const top_est = { nticks: range / top.size, label_width: Math.max(normal, major) };
      let bottom_est;
      if (bottom) {
        const short = measure_max_label_width(bottom.short_fmt, ctx, opts);
        const long = may_be_long && bottom.long_fmt ? measure_max_label_width(bottom.long_fmt, ctx, opts) : 0;
        bottom_est = { nticks: range / bottom.size, label_width: Math.max(short, long) };
      }
      return { top: top_est, bottom: bottom_est };
    }
    format(dt, is_major, with_bottom, prefer_long_bottom) {
      const top = dt.toLocaleString(is_major && this.top.maj_fmt ? this.top.maj_fmt : this.top.fmt);
      if (!with_bottom || !this.bottom)
        return top;
      const bottom = dt.toLocaleString(
        prefer_long_bottom && this.bottom.long_fmt ? this.bottom.long_fmt : this.bottom.short_fmt
      );
      return [top, bottom];
    }
    create(from, to, prefer_long_bottom) {
      const ticks = [];
      for (const { dt, is_major, with_bottom } of this.seq(from)) {
        if (dt < from)
          continue;
        if (dt >= to)
          break;
        ticks.push({
          value: dt.toMillis(),
          major: is_major,
          label: this.format(dt, is_major, with_bottom, prefer_long_bottom(dt))
        });
      }
      return ticks;
    }
    create_floating(dt, pos, prefer_long_bottom) {
      const bottom = this.bottom;
      const fmt = bottom ? prefer_long_bottom(dt) && bottom.long_fmt ? bottom.long_fmt : bottom.short_fmt : void 0;
      const text = fmt ? dt.toLocaleString(fmt) : "";
      return { value: dt.toMillis(), label: ["", pos === "left" ? "\u2026" + text : text + "\u2026"] };
    }
    // Convenience method to apply some global changes to formats.
    // Intended to override hour12, numeric => 2-digit etc
    patch_formats(patch) {
      var _a, _b;
      function apply(dst) {
        for (const e of Object.entries(patch)) {
          const k = e[0];
          const v = e[1];
          if (k === "hour12" && dst.hour)
            dst.hour12 = v;
          if (dst[k])
            dst[k] = e[1];
        }
      }
      apply(this.top.fmt);
      this.top.maj_fmt && apply(this.top.maj_fmt);
      ((_a = this.bottom) == null ? void 0 : _a.short_fmt) && apply(this.bottom.short_fmt);
      ((_b = this.bottom) == null ? void 0 : _b.long_fmt) && apply(this.bottom.long_fmt);
    }
  };
  var MonoTickGenerator = class extends TickGenerator {
    constructor(top, bottom) {
      const { fmt, maj_fmt, align, maj_unit, ...top_duration } = top;
      super(
        {
          fmt,
          maj_fmt,
          size: import_luxon2.Duration.fromDurationLike(top_duration).toMillis()
        },
        bottom && {
          ...bottom,
          size: import_luxon2.Duration.fromObject({ [bottom.unit]: 1 }).toMillis()
        }
      );
      this.step = top_duration;
      this.bottom_unit = bottom == null ? void 0 : bottom.unit;
      this.align = align;
      this.maj_unit = maj_unit;
    }
    *seq(from) {
      let dt = from.startOf(this.align);
      while (true) {
        const with_bottom = this.bottom_unit ? dt.startOf(this.bottom_unit).equals(dt) : false;
        const is_major = this.maj_unit ? dt.startOf(this.maj_unit).equals(dt) : false;
        yield { dt, is_major, with_bottom };
        dt = dt.plus(this.step);
      }
    }
  };
  var DaysTickGenerator = class extends TickGenerator {
    constructor(top, bottom) {
      super(
        {
          ...top,
          size: top.step * 86400 * 1e3
        },
        bottom && {
          ...bottom,
          size: 30 * 86400 * 1e3
        }
      );
      this.days = top.days;
      this.maj_days = top.maj_days ?? [1];
      this.bottom_days = bottom ? bottom.days ?? [1] : [];
    }
    *seq(from) {
      let mdt = from.startOf("month");
      while (true) {
        for (const day of this.days) {
          const dt = mdt.set({ day });
          const is_major = this.maj_days.includes(day);
          const with_bottom = this.bottom_days.includes(day);
          yield { dt, is_major, with_bottom };
        }
        mdt = mdt.plus({ month: 1 });
      }
    }
  };
  var YearsTickGenerator = class extends TickGenerator {
    constructor(by_years, top) {
      super({
        ...top,
        size: by_years * 365 * 86400 * 1e3
      });
      this.by_years = by_years;
    }
    *seq(from) {
      const start = (from.year / this.by_years | 0) * this.by_years;
      let dt = from.startOf("year").set({ year: start });
      while (true) {
        yield { dt, is_major: false, with_bottom: false };
        dt = dt.plus({ year: this.by_years });
      }
    }
  };

  // src/defgens.ts
  var HMS = {
    hour: "numeric",
    minute: "numeric",
    second: "numeric"
  };
  var HM = {
    hour: "numeric",
    minute: "numeric"
  };
  var MDAY = {
    day: "numeric"
  };
  var MON = {
    month: "short"
  };
  var YEAR = {
    year: "numeric"
  };
  var YMD = {
    year: "numeric",
    month: "short",
    day: "numeric"
  };
  var YM = {
    year: "numeric",
    month: "short"
  };
  var MD = {
    month: "short",
    day: "numeric"
  };
  var DEF_TICK_GENERATORS = [
    // seconds
    new MonoTickGenerator(
      { second: 1, align: "second", maj_unit: "minute", fmt: HMS, maj_fmt: HM },
      { unit: "day", short_fmt: MD, long_fmt: YMD }
    ),
    new MonoTickGenerator(
      { second: 5, align: "minute", maj_unit: "minute", fmt: HMS, maj_fmt: HM },
      { unit: "day", short_fmt: MD, long_fmt: YMD }
    ),
    new MonoTickGenerator(
      { second: 10, align: "minute", maj_unit: "minute", fmt: HMS, maj_fmt: HM },
      { unit: "day", short_fmt: MD, long_fmt: YMD }
    ),
    new MonoTickGenerator(
      { second: 30, align: "minute", maj_unit: "minute", fmt: HMS, maj_fmt: HM },
      { unit: "day", short_fmt: MD, long_fmt: YMD }
    ),
    // minutes
    new MonoTickGenerator(
      { minute: 1, align: "minute", maj_unit: "hour", fmt: HM },
      { unit: "day", short_fmt: MD, long_fmt: YMD }
    ),
    new MonoTickGenerator(
      { minute: 5, align: "hour", maj_unit: "hour", fmt: HM },
      { unit: "day", short_fmt: MD, long_fmt: YMD }
    ),
    new MonoTickGenerator(
      { minute: 10, align: "hour", maj_unit: "hour", fmt: HM },
      { unit: "day", short_fmt: MD, long_fmt: YMD }
    ),
    new MonoTickGenerator(
      { minute: 15, align: "hour", maj_unit: "hour", fmt: HM },
      { unit: "day", short_fmt: MD, long_fmt: YMD }
    ),
    new MonoTickGenerator(
      { minute: 30, align: "hour", maj_unit: "hour", fmt: HM },
      { unit: "day", short_fmt: MD, long_fmt: YMD }
    ),
    // hours
    new MonoTickGenerator(
      { hour: 1, align: "hour", maj_unit: "day", fmt: HM },
      { unit: "day", short_fmt: MD, long_fmt: YMD }
    ),
    new MonoTickGenerator(
      { hour: 3, align: "day", maj_unit: "day", fmt: HM },
      { unit: "day", short_fmt: MD, long_fmt: YMD }
    ),
    new MonoTickGenerator(
      { hour: 6, align: "day", maj_unit: "day", fmt: HM },
      { unit: "day", short_fmt: MD, long_fmt: YMD }
    ),
    new MonoTickGenerator(
      { hour: 12, align: "day", maj_unit: "day", fmt: HM },
      { unit: "day", short_fmt: MD, long_fmt: YMD }
    ),
    // days
    new MonoTickGenerator(
      { day: 1, align: "day", maj_unit: "month", fmt: MDAY },
      { unit: "month", short_fmt: MON, long_fmt: YM }
    ),
    new DaysTickGenerator({ days: [1, 5, 10, 15, 20, 25], step: 5, fmt: MDAY }, { short_fmt: MON, long_fmt: YM }),
    new DaysTickGenerator({ days: [1, 10, 20], step: 10, fmt: MDAY }, { short_fmt: MON, long_fmt: YM }),
    new DaysTickGenerator({ days: [1, 15], step: 15, fmt: MDAY }, { short_fmt: MON, long_fmt: YM }),
    // months. luxon threats month duration as 30 days in default 'casual' mode
    new MonoTickGenerator({ month: 1, align: "month", maj_unit: "year", fmt: MON }, { unit: "year", short_fmt: YEAR }),
    new MonoTickGenerator({ month: 3, align: "year", maj_unit: "year", fmt: MON }, { unit: "year", short_fmt: YEAR }),
    new MonoTickGenerator({ month: 6, align: "year", maj_unit: "year", fmt: MON }, { unit: "year", short_fmt: YEAR }),
    // years. year duration is 365 days by default
    new YearsTickGenerator(1, { fmt: YEAR }),
    new YearsTickGenerator(5, { fmt: YEAR }),
    new YearsTickGenerator(10, { fmt: YEAR }),
    new YearsTickGenerator(25, { fmt: YEAR }),
    new YearsTickGenerator(50, { fmt: YEAR }),
    new YearsTickGenerator(100, { fmt: YEAR }),
    // fallback )
    new YearsTickGenerator(1e3, { fmt: YEAR })
  ];

  // src/scale.ts
  var DEF_TOOLTIP_FORMAT = {
    year: "numeric",
    month: "long",
    day: "numeric",
    hour: "numeric",
    minute: "numeric",
    second: "numeric"
  };
  var TimestackScale = class extends import_chart.Scale {
    constructor(cfg) {
      var _a, _b, _c, _d, _e;
      super(cfg);
      const opts = (_c = (_b = (_a = cfg.chart) == null ? void 0 : _a.config.options) == null ? void 0 : _b.scales) == null ? void 0 : _c[cfg.id];
      const gens = ((_d = opts == null ? void 0 : opts.timestack) == null ? void 0 : _d.make_tick_generators) ? (_e = opts == null ? void 0 : opts.timestack) == null ? void 0 : _e.make_tick_generators() : DEF_TICK_GENERATORS;
      this._gens = gens;
      if (opts == null ? void 0 : opts.timestack.format_style) {
        for (const gen of gens) {
          gen.patch_formats(opts == null ? void 0 : opts.timestack.format_style);
        }
      }
    }
    init(options) {
      this._dt_opts = options.timestack.datetime ?? {};
      super.init(options);
    }
    determineDataLimits() {
      let { min, max } = this.getMinMax(false);
      min = isFinite(min) ? min : this._dt_now().startOf("day").toMillis();
      max = isFinite(max) ? max : this._dt_now().endOf("day").toMillis() + 1;
      this.min = Math.min(min, max - 1);
      this.max = Math.max(min + 1, max);
    }
    _dt_from_ts(ts) {
      return import_luxon3.DateTime.fromMillis(ts, this._dt_opts);
    }
    _dt_from_object(obj) {
      return import_luxon3.DateTime.fromObject(obj, this._dt_opts);
    }
    _dt_now() {
      return import_luxon3.DateTime.local(this._dt_opts);
    }
    // Choosing the generator with density < max density and closest to the wanted one.
    // Then number of ticks is checked against the maxTicksLimit too
    _choose_gen(range) {
      const gens = this._gens;
      const density_limit = this.options.timestack.max_density;
      const want_density = this.options.timestack.density;
      const nticks_limit = this.options.ticks.maxTicksLimit ?? Infinity;
      const candidates = [];
      for (const gen of gens) {
        const { top, bottom } = gen.estimate(range, this.ctx, this._dt_opts);
        const max_nticks = Math.max(top.nticks, (bottom == null ? void 0 : bottom.nticks) ?? 0);
        const top_density = top.nticks * top.label_width / this.width;
        const bottom_density = bottom ? bottom.nticks * bottom.label_width / this.width : 0;
        const max_density = Math.max(top_density, bottom_density);
        if (max_density <= density_limit && max_nticks <= nticks_limit) {
          candidates.push([gen, Math.abs(max_density - want_density)]);
        }
      }
      if (!candidates.length)
        return void 0;
      const best = candidates.reduce((prev, cur) => cur[1] < prev[1] ? cur : prev);
      return best[0];
    }
    _need_floating_left_tick(ticks_with_bottoms) {
      const thres = this.options.timestack.left_floating_tick_thres;
      if (thres === false)
        return false;
      if (!ticks_with_bottoms.length)
        return true;
      const neigh_rel = (ticks_with_bottoms[0].value - this.min) / (this.max - this.min);
      return neigh_rel > thres;
    }
    _need_floating_right_tick(ticks_with_bottoms) {
      const thres = this.options.timestack.right_floating_tick_thres;
      if (thres === false)
        return false;
      if (!ticks_with_bottoms.length)
        return true;
      const neigh_rel = (this.max - ticks_with_bottoms[ticks_with_bottoms.length - 1].value) / (this.max - this.min);
      return neigh_rel > thres;
    }
    _build_ticks() {
      const { min, max } = this;
      const gen = this._choose_gen(max - min);
      if (!gen) {
        console.warn("Failed to choose the tick generator");
        return [];
      }
      const min_dt = this._dt_from_ts(min);
      const max_dt = this._dt_from_ts(max);
      const now_dt = this._dt_now();
      const prefer_long_bottom = (dt) => !dt.hasSame(now_dt, "year");
      const ticks = gen.create(min_dt, max_dt, prefer_long_bottom);
      if (!gen.bottom)
        return ticks;
      const ticks_with_bottoms = ticks.filter((t) => Array.isArray(t.label) && t.label.length > 1);
      if (this._need_floating_left_tick(ticks_with_bottoms)) {
        let tick;
        tick = gen.create_floating(min_dt, "left", prefer_long_bottom);
        if (ticks_with_bottoms.length) {
          const neigh = ticks_with_bottoms[0];
          const width = this.ctx.measureText(tick.label[1]).width;
          const space = (neigh.value - this.min) * this.width / (this.max - this.min);
          if (width * 2 > space)
            tick = void 0;
        }
        if (tick)
          ticks.unshift(tick);
      }
      if (this._need_floating_right_tick(ticks_with_bottoms)) {
        let tick;
        tick = gen.create_floating(max_dt, "right", prefer_long_bottom);
        if (ticks_with_bottoms.length) {
          const neigh = ticks_with_bottoms[ticks_with_bottoms.length - 1];
          const width = this.ctx.measureText(tick.label[1]).width;
          const space = (this.max - neigh.value) * this.width / (this.max - this.min);
          if (width * 2 > space)
            tick = void 0;
        }
        if (tick)
          ticks.push(tick);
      }
      return ticks;
    }
    buildTicks() {
      let font;
      try {
        font = this._resolveTickFontOptions(0).string;
      } catch {
        console.warn("failed to resolve the font");
      }
      this.ctx.save();
      if (font)
        this.ctx.font = font;
      const ticks = this._build_ticks();
      this.ctx.restore();
      return ticks;
    }
    getLabelForValue(value) {
      return this._dt_from_ts(value).toLocaleString(this.options.timestack.tooltip_format);
    }
    // noop. ticks are already generated in single pass
    generateTickLabels(ticks) {
    }
    // took these from timescale w/o offsets
    getPixelForValue(value) {
      const pos = value === null ? NaN : (value - this.min) / (this.max - this.min);
      return this.getPixelForDecimal(pos);
    }
    getValueForPixel(pixel) {
      const pos = this.getDecimalForPixel(pixel);
      return this.min + pos * (this.max - this.min);
    }
  };
  TimestackScale.id = "timestack";
  TimestackScale.defaults = {
    timestack: {
      tooltip_format: DEF_TOOLTIP_FORMAT,
      density: 0.5,
      max_density: 0.75,
      left_floating_tick_thres: 0.33,
      right_floating_tick_thres: false
    },
    ticks: {
      // @ts-ignore : this one is needed to prevent the autoSkip purging our ticks.
      // otherwise autoSkip=false is ignored by the core Scale class
      source: "",
      maxRotation: 0,
      autoSkip: false
    }
  };

  // src/index.ts
  import_chart2.Chart.register(TimestackScale);
  return __toCommonJS(src_exports);
})();
