import type { CartesianScaleOptions, Tick, Chart } from 'chart.js';
import type { DeepPartial } from 'chart.js/dist/types/utils';
import type { DateTimeJSOptions, DateObjectUnits } from 'luxon';
import type { TickGenerator } from './ticks';
import { Scale } from 'chart.js';
export interface TimestackScaleOptions extends CartesianScaleOptions {
    timestack: {
        /**
         Luxon DateTime creation options (zone, locale, etc)
         */
        datetime: DateTimeJSOptions;
        /**
          Desired labels density [0..1]. Defined as total labels width / scale width
          @default 0.5
         */
        density: number;
        /**
          Maximum labels density
          @default 0.75
         */
        max_density: number;
        /**
          Tooltip format options
          */
        tooltip_format: Intl.DateTimeFormatOptions;
        /**
          Add left bottom tick with ellipsis if there are no bottom ticks in first _[thres * axis_width]_ part of scale. Set `false` to disable the feature
          @default 0.33 (first 1/3 of scale width)
         */
        left_floating_tick_thres: number | false;
        /**
          Add right bottom tick with ellipsis if there are no bottom ticks in last _[thres * axis_width]_ part of scale. Set `false` to disable the feature
          @default false
         */
        right_floating_tick_thres: number | false;
        /**
          Factory function returning array of tick generators to replace the default ones. Would be called just once at chart creation
         */
        make_tick_generators: () => TickGenerator[];
        /**
          Formatting options _(Intl.DateTimeFormatOptions)_ to customize the default tick generators format style. i.e. `{hour12: true, month: 'long', minute: '2-digit'}` etc
          @default undefined
         */
        format_style: Intl.DateTimeFormatOptions;
    };
}
export declare const DEF_TOOLTIP_FORMAT: Intl.DateTimeFormatOptions;
export declare class TimestackScale extends Scale<TimestackScaleOptions> {
    static id: string;
    static defaults: DeepPartial<TimestackScaleOptions>;
    _gens: TickGenerator[];
    _dt_opts: DateTimeJSOptions;
    constructor(cfg: {
        id: string;
        type: string;
        ctx: CanvasRenderingContext2D;
        chart: Chart;
    });
    init(options: TimestackScaleOptions): void;
    determineDataLimits(): void;
    _dt_from_ts(ts: number): any;
    _dt_from_object(obj: DateObjectUnits): any;
    _dt_now(): any;
    _choose_gen(range: number): TickGenerator;
    _need_floating_left_tick(ticks_with_bottoms: Tick[]): boolean;
    _need_floating_right_tick(ticks_with_bottoms: Tick[]): boolean;
    _build_ticks(): Tick[];
    buildTicks(): Tick[];
    getLabelForValue(value: number): any;
    generateTickLabels(ticks: Tick[]): void;
    getPixelForValue(value: number | null): number;
    getValueForPixel(pixel: number): number;
}
