import type { Tick } from 'chart.js';
import type { DateTimeUnit, DurationLike, DurationLikeObject, DateTimeJSOptions } from 'luxon';
import { DateTime } from 'luxon';
export interface TopTickSpec {
    fmt: Intl.DateTimeFormatOptions;
    maj_fmt?: Intl.DateTimeFormatOptions;
}
export interface BottomTickSpec {
    short_fmt: Intl.DateTimeFormatOptions;
    long_fmt?: Intl.DateTimeFormatOptions;
}
interface SeqTick {
    dt: DateTime;
    is_major: boolean;
    with_bottom: boolean;
}
/**
  Base tick generator class.
  Concrete tick generators must implement the *seq method
*/
export declare class TickGenerator {
    top: TopTickSpec & {
        size: number;
    };
    bottom?: BottomTickSpec & {
        size: number;
    };
    /** Generator yielding (possibly infinite) sequence of _SeqTick-s. It's ok to return the ticks
     * before the 'from'
     */
    seq(from: DateTime): Generator<SeqTick>;
    constructor(top: TopTickSpec & {
        size: number;
    }, bottom?: BottomTickSpec & {
        size: number;
    });
    estimate(range: number, ctx: CanvasRenderingContext2D, opts: DateTimeJSOptions, may_be_long?: boolean): {
        top: {
            nticks: number;
            label_width: number;
        };
        bottom: any;
    };
    format(dt: DateTime, is_major: boolean, with_bottom: boolean, prefer_long_bottom: boolean): any;
    create(from: DateTime, to: DateTime, prefer_long_bottom: (dt: DateTime) => boolean): Tick[];
    create_floating(dt: DateTime, pos: 'left' | 'right', prefer_long_bottom: (dt: DateTime) => boolean): {
        value: any;
        label: string[];
    };
    patch_formats(patch: Intl.DateTimeFormatOptions): void;
}
export declare class MonoTickGenerator extends TickGenerator {
    step: DurationLike;
    align: DateTimeUnit;
    bottom_unit?: DateTimeUnit;
    maj_unit?: DateTimeUnit;
    constructor(top: TopTickSpec & DurationLikeObject & {
        align: DateTimeUnit;
        maj_unit?: DateTimeUnit;
    }, bottom: (BottomTickSpec & {
        unit: DateTimeUnit;
    }) | undefined);
    seq(from: DateTime): Generator<{
        dt: any;
        is_major: any;
        with_bottom: any;
    }, void, unknown>;
}
export declare class DaysTickGenerator extends TickGenerator {
    days: number[];
    maj_days: number[];
    bottom_days: number[];
    constructor(top: TopTickSpec & {
        days: number[];
        step: number;
        maj_days?: number[];
    }, bottom?: BottomTickSpec & {
        days?: number[];
    });
    seq(from: DateTime): Generator<{
        dt: any;
        is_major: boolean;
        with_bottom: boolean;
    }, void, unknown>;
}
export declare class YearsTickGenerator extends TickGenerator {
    by_years: number;
    constructor(by_years: number, top: TopTickSpec);
    seq(from: DateTime): Generator<{
        dt: any;
        is_major: boolean;
        with_bottom: boolean;
    }, void, unknown>;
}
export {};
