[chessboard.js](http://chessboardjs.com) - JavaScript Chess Board
==================================================

What is chessboard.js?
--------------------------------------

chessboard.js is a standalone JavaScript Chess Board. It is designed to be "just a board" and expose a powerful API so that it can be used in different ways. Here's a non-exhaustive list of things you can do with chessboard.js:

- Use chessboard.js to show game positions alongside your expert commentary.
- Use chessboard.js to have a tactics website where users have to guess the best move.
- Integrate chessboard.js and [chess.js](https://github.com/jhlywa/chess.js) with a PGN database and allow people to search and playback games (see [Example 5000](http://chessboardjs.com/examples#5000))
- Build a chess server and have users play their games out using the chessboard.js board.

chessboard.js is flexible enough to handle any of these situations with relative ease.

What is chessboard.js not?
--------------------------------------

Here is a list of things that chessboard.js is **not**:

- A chess engine
- A legal move validator
- A PGN parser

chessboard.js is designed to work well with any of those things, but the idea behind chessboard.js is that the logic that controls the board should be independent of those other problems.

Docs and Examples
--------------------------------------

- Docs - <http://chessboardjs.com/docs>
- Examples - <http://chessboardjs.com/examples>

License
--------------------------------------

chessboard.js is released under the [MIT License](https://github.com/oakmac/chessboardjs/blob/master/LICENSE).
