import * as cg from './types';
export declare const colors: cg.Color[];
export declare const invRanks: cg.Rank[];
export declare const allKeys: cg.Key[];
export declare const pos2key: (pos: [number, number]) => cg.Key;
export declare const key2pos: (k: cg.Key) => [number, number];
export declare function memo<A>(f: () => A): cg.Memo<A>;
export declare const timer: () => cg.Timer;
export declare const opposite: (c: cg.Color) => "white" | "black";
export declare function containsX<X>(xs: X[] | undefined, x: X): boolean;
export declare const distanceSq: (pos1: cg.Pos, pos2: cg.Pos) => number;
export declare const samePiece: (p1: cg.Piece, p2: cg.Piece) => boolean;
export declare const computeIsTrident: () => boolean;
export declare const posToTranslateAbs: (bounds: ClientRect) => (pos: [number, number], asWhite: boolean) => [number, number];
export declare const posToTranslateRel: (pos: cg.Pos, asWhite: boolean) => cg.NumberPair;
export declare const translateAbs: (el: HTMLElement, pos: [number, number]) => void;
export declare const translateRel: (el: HTMLElement, percents: [number, number]) => void;
export declare const setVisible: (el: HTMLElement, v: boolean) => void;
export declare const eventPosition: (e: cg.MouchEvent) => cg.NumberPair | undefined;
export declare const isRightButton: (e: MouseEvent) => boolean;
export declare const createEl: (tagName: string, className?: string | undefined) => HTMLElement;
export declare const raf: any;
