import { AjaxFn, ClassNames, FuseOptions, IChoicesProps, IChoicesMethods, ItemFilterFn, NoResultsTextFn, NoChoicesTextFn, AddItemTextFn, MaxItemTextFn, SortFn, OnInit, OnCreateTemplates, UniqueItemText, ValueCompareFunction, CustomAddItemText } from './interfaces';
export declare class ChoicesJSStencil implements IChoicesProps, IChoicesMethods {
    type?: 'single' | 'multiple' | 'text';
    value: string;
    name: string;
    silent: boolean;
    items: Array<any>;
    choices: Array<any>;
    renderChoiceLimit: number;
    maxItemCount: number;
    addItems: boolean;
    removeItems: boolean;
    removeItemButton: boolean;
    editItems: boolean;
    duplicateItemsAllowed: boolean;
    delimiter: string;
    paste: boolean;
    searchEnabled: boolean;
    searchChoices: boolean;
    searchFields: Array<string> | string;
    searchFloor: number;
    searchResultLimit: number;
    position: 'auto' | 'top' | 'bottom';
    resetScrollPosition: boolean;
    shouldSort: boolean;
    shouldSortItems: boolean;
    sorter: SortFn;
    placeholder: boolean | string;
    placeholderValue: string;
    searchPlaceholderValue: string;
    prependValue: string;
    appendValue: string;
    renderSelectedChoices: 'always' | 'auto';
    loadingText: string;
    noResultsText: string | NoResultsTextFn;
    noChoicesText: string | NoChoicesTextFn;
    itemSelectText: string;
    addItemText: string | AddItemTextFn;
    maxItemText: string | MaxItemTextFn;
    uniqueItemText: UniqueItemText;
    classNames: ClassNames;
    fuseOptions: FuseOptions;
    addItemFilter: string | RegExp | ItemFilterFn;
    customAddItemText: CustomAddItemText;
    callbackOnInit: OnInit;
    callbackOnCreateTemplates: OnCreateTemplates;
    valueComparer: ValueCompareFunction;
    private readonly root;
    private choice;
    private element;
    highlightItem(item: HTMLElement, runEvent?: boolean): Promise<this>;
    unhighlightItem(item: HTMLElement): Promise<this>;
    highlightAll(): Promise<this>;
    unhighlightAll(): Promise<this>;
    removeActiveItemsByValue(value: string): Promise<this>;
    removeActiveItems(excludedId?: number): Promise<this>;
    removeHighlightedItems(runEvent?: boolean): Promise<this>;
    showDropdown(focusInput?: boolean): Promise<this>;
    hideDropdown(blurInput?: boolean): Promise<this>;
    getValue(valueOnly?: boolean): Promise<string | Array<string>>;
    setValue(args: Array<any>): Promise<this>;
    setChoiceByValue(value: string | Array<string>): Promise<this>;
    setChoices(choices: Array<any>, value: string, label: string, replaceChoices?: boolean): Promise<this>;
    clearChoices(): Promise<this>;
    clearStore(): Promise<this>;
    clearInput(): Promise<this>;
    enable(): Promise<this>;
    disable(): Promise<this>;
    ajax(fn: AjaxFn): Promise<this>;
    protected componentDidLoad(): void;
    protected componentDidUpdate(): void;
    protected componentDidUnload(): void;
    protected render(): any;
    private init;
    private destroy;
    private createSelectOptions;
}
