module.exports = (grunt) ->
  require('load-grunt-tasks')(grunt);

  version = ->
    grunt.file.readJSON("package.json").version
  version_tag = ->
    "v#{version()}"

  grunt.initConfig
    pkg: grunt.file.readJSON("package.json")
    comments: """
/*!
Chosen, a Select Box Enhancer for jQuery and Prototype
by Patrick Filler for Harvest, http://getharvest.com

Version <%= pkg.version %>
Full source at https://github.com/harvesthq/chosen
Copyright (c) 2011-<%= grunt.template.today('yyyy') %> Harvest http://getharvest.com

MIT License, https://github.com/harvesthq/chosen/blob/master/LICENSE.md
This file is generated by `grunt build`, do not edit it by hand.
*/
\n
"""
    minified_comments: "/* Chosen #{version_tag()} | (c) 2011-<%= grunt.template.today('yyyy') %> by Harvest | MIT License, https://github.com/harvesthq/chosen/blob/master/LICENSE.md */\n"

    concat:
      options:
        banner: "<%= comments %>"
      jquery:
        src: ["public/chosen.jquery.js"]
        dest: "public/chosen.jquery.js"
      proto:
        src: ["public/chosen.proto.js"]
        dest: "public/chosen.proto.js"
      css:
        src: ["public/chosen.css"]
        dest: "public/chosen.css"

    coffee:
      options:
        join: true
      compile:
        files:
          'public/chosen.jquery.js': ['coffee/lib/select-parser.coffee', 'coffee/lib/abstract-chosen.coffee', 'coffee/chosen.jquery.coffee']
          'public/chosen.proto.js': ['coffee/lib/select-parser.coffee', 'coffee/lib/abstract-chosen.coffee', 'coffee/chosen.proto.coffee']
          'spec/public/jquery_specs.js': 'spec/jquery/*.spec.coffee'
          'spec/public/proto_specs.js': 'spec/proto/*.spec.coffee'

    uglify:
      options:
        mangle:
          except: ['jQuery', 'AbstractChosen', 'Chosen', 'SelectParser']
        banner: "<%= minified_comments %>"
      minified_chosen_js:
        files:
          'public/chosen.jquery.min.js': ['public/chosen.jquery.js']
          'public/chosen.proto.min.js': ['public/chosen.proto.js']

    compass:
      chosen_css:
        options:
          trace: true
          bundleExec: true
          specify: ['sass/chosen.scss']

    cssmin:
      minified_chosen_css:
        options:
          banner: "<%= minified_comments %>"
          keepSpecialComments: 0
        src: 'public/chosen.css'
        dest: 'public/chosen.min.css'

    watch:
      scripts:
        files: ['coffee/**/*.coffee', 'sass/*.scss']
        tasks: ['build']

    dom_munger:
      latest_version:
        src: ['public/index.html', 'public/index.proto.html', 'public/options.html']
        options:
          callback: ($) ->
            $("#latest-version").text(version_tag())
    zip:
      chosen:
        cwd: 'public/'
        src: ['public/**/*']
        dest: "chosen_#{version_tag()}.zip"

    'gh-pages':
      options:
        base: 'public',
        message: "Updated to new Chosen version #{version()}"
      src: ['**']

    jasmine:
      jquery:
        src: [ 'public/chosen.jquery.js' ]
        options:
          vendor: [ 'http://ajax.googleapis.com/ajax/libs/jquery/1.9.1/jquery.min.js' ]
          specs: 'spec/public/jquery_specs.js'
      proto:
        src: [ 'public/chosen.proto.js' ]
        options:
          vendor: [
            'https://ajax.googleapis.com/ajax/libs/prototype/1.7.0.0/prototype.js',
            'public/docsupport/event.simulate.js'
          ]
          specs: 'spec/public/proto_specs.js'

  grunt.registerTask 'default', ['build']
  grunt.registerTask 'build', ['coffee', 'compass', 'concat', 'uglify', 'cssmin', 'package-bower']
  grunt.registerTask 'prep-release', ['build', 'dom_munger:latest_version', 'zip:chosen','package-jquery']
  grunt.registerTask 'test',  ['coffee', 'jasmine']

  grunt.registerTask 'publish-release', ['gh-pages']

  grunt.registerTask 'package-jquery', 'Generate a jquery.json manifest file from package.json', () ->
    src = "package.json"
    dest = "chosen.jquery.json"
    pkg = grunt.file.readJSON(src)
    json1 =
      "name": pkg.name
      "description": pkg.description
      "version": version()
      "licenses": pkg.licenses
    json2 = pkg.jqueryJSON
    json1[key] = json2[key] for key of json2
    json1.author.name = pkg.author
    grunt.file.write('chosen.jquery.json', JSON.stringify(json1, null, 2) + "\n")

  grunt.registerTask 'package-bower', 'Generate a bower.json manifest file from package.json', () ->
    pkg = grunt.file.readJSON("package.json")
    bowerjson = pkg.bowerJSON
    jqueryjson = pkg.jqueryJSON

    bower =
      "name": pkg.name
      "description": pkg.description
      "version": version()
      "main": bowerjson.main
      "license": pkg.licenses
      "ignore": []
      "keywords": jqueryjson.keywords
      "authors": jqueryjson.maintainers
      "homepage": jqueryjson.homepage
      "repository": pkg.repository
      "dependencies": jqueryjson.dependencies
      "devDependencies": []

    grunt.file.write("public/bower.json", JSON.stringify(bower, null, 2) + "\n")

  grunt.registerTask 'cleanup-bower', 'Delete generated bower.json file', () ->
    grunt.file.delete("public/bower.json")
