module.exports = {
  ILLUMINANTS: {
    // From ASTM E308-01
    A: { X: 1.09850 * 100, Y: 1.00000 * 100, Z: 0.35585 * 100 },

    // From Wyszecki & Stiles, p. 769
    B: { X: 0.99072 * 100, Y: 1.00000 * 100, Z: 0.85223 * 100 },

    // From ASTM E308-01
    C: { X: 0.98074 * 100, Y: 1.00000 * 100, Z: 1.18232 * 100 },

    // From ASTM E308-01
    D50: { X: 0.96422 * 100, Y: 1.00000 * 100, Z: 0.82521 * 100 },

    // From ASTM E308-01
    D55: { X: 0.95682 * 100, Y: 1.00000 * 100, Z: 0.92149 * 100 },

    // From ASTM E308-01
    D65: { X: 0.95047 * 100, Y: 1.00000 * 100, Z: 1.08883 * 100 },

    // From ASTM E308-01
    D75: { X: 0.94972 * 100, Y: 1.00000 * 100, Z: 1.22638 * 100 },

    // From ASTM E308-01
    E: { X: 1.00000 * 100, Y: 1.00000 * 100, Z: 1.00000 * 100 },

    // From ASTM E308-01
    F2: { X: 0.99186 * 100, Y: 1.00000 * 100, Z: 0.67393 * 100 },

    // From ASTM E308-01
    F7: { X: 0.95041 * 100, Y: 1.00000 * 100, Z: 1.08747 * 100 },

    // From ASTM E308-01
    F11: { X: 1.00962 * 100, Y: 1.00000 * 100, Z: 0.64350 * 100 }
  },
  TRANSFORMS: {
    BRADFORD: [
      [ 0.8951000, 0.2664000, -0.1614000 ],
      [ -0.7502000, 1.7135000, 0.0367000 ],
      [ 0.0389000, -0.0685000, 1.0296000 ]
    ],
    INVERSE_BRADFORD: [
      [ 0.9869929, -0.1470543, 0.1599627 ],
      [ 0.4323053, 0.5183603, 0.0492912 ],
      [ -0.0085287, 0.0400428, 0.9684867 ]
    ],
    SRGB_XYZ: [
      [ 0.4124, 0.3576, 0.1805 ],
      [ 0.2126, 0.7152, 0.0722 ],
      [ 0.0193, 0.1192, 0.9505 ]
    ],
    INVERSE_SRGB_XYZ: [
      [ 3.2406, -1.5372, -0.4986 ],
      [ -0.9689, 1.8758, 0.0415 ],
      [ 0.0557, -0.2040, 1.0570 ]
    ]
  }
}
