/**
 * Copyright 2021 Google LLC.
 * Copyright (c) Microsoft Corporation.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
import Protocol from 'devtools-protocol';
import { BrowsingContext, CDP, Script } from '../../../protocol/protocol.js';
import { CdpConnection } from '../../CdpConnection.js';
import { LoggerFn } from '../../../utils/log.js';
import { IEventManager } from '../events/EventManager.js';
import { RealmStorage } from '../script/realmStorage.js';
import { BrowsingContextStorage } from './browsingContextStorage.js';
export declare class BrowsingContextProcessor {
    #private;
    constructor(realmStorage: RealmStorage, cdpConnection: CdpConnection, selfTargetId: string, eventManager: IEventManager, browsingContextStorage: BrowsingContextStorage, logger?: LoggerFn);
    process_browsingContext_getTree(params: BrowsingContext.GetTreeParameters): BrowsingContext.GetTreeResult;
    process_browsingContext_create(params: BrowsingContext.CreateParameters): Promise<BrowsingContext.CreateResult>;
    process_browsingContext_navigate(params: BrowsingContext.NavigateParameters): Promise<BrowsingContext.NavigateResult>;
    process_browsingContext_captureScreenshot(params: BrowsingContext.CaptureScreenshotParameters): Promise<BrowsingContext.CaptureScreenshotResult>;
    process_browsingContext_print(params: BrowsingContext.PrintParameters): Promise<BrowsingContext.PrintResult>;
    process_script_addPreloadScript(params: Script.AddPreloadScriptParameters): Promise<Script.AddPreloadScriptResult>;
    process_script_removePreloadScript(_params: Script.RemovePreloadScriptParameters): Promise<Script.RemovePreloadScriptResult>;
    process_script_evaluate(params: Script.EvaluateParameters): Promise<Script.EvaluateResult>;
    process_script_getRealms(params: Script.GetRealmsParameters): Script.GetRealmsResult;
    process_script_callFunction(params: Script.CallFunctionParameters): Promise<Script.CallFunctionResult>;
    process_script_disown(params: Script.DisownParameters): Promise<Script.DisownResult>;
    process_browsingContext_close(commandParams: BrowsingContext.CloseParameters): Promise<BrowsingContext.CloseResult>;
    process_cdp_sendCommand(params: CDP.SendCommandParams): Promise<{
        result: void | Protocol.Debugger.EnableResponse | Protocol.Debugger.EvaluateOnCallFrameResponse | Protocol.Debugger.GetPossibleBreakpointsResponse | Protocol.Debugger.GetScriptSourceResponse | Protocol.Debugger.DisassembleWasmModuleResponse | Protocol.Debugger.NextWasmDisassemblyChunkResponse | Protocol.Debugger.GetWasmBytecodeResponse | Protocol.Debugger.GetStackTraceResponse | Protocol.Debugger.RestartFrameResponse | Protocol.Debugger.SearchInContentResponse | Protocol.Debugger.SetBreakpointResponse | Protocol.Debugger.SetInstrumentationBreakpointResponse | Protocol.Debugger.SetBreakpointByUrlResponse | Protocol.Debugger.SetBreakpointOnFunctionCallResponse | Protocol.Debugger.SetScriptSourceResponse | Protocol.HeapProfiler.GetHeapObjectIdResponse | Protocol.HeapProfiler.GetObjectByHeapObjectIdResponse | Protocol.HeapProfiler.GetSamplingProfileResponse | Protocol.HeapProfiler.StopSamplingResponse | Protocol.Profiler.GetBestEffortCoverageResponse | Protocol.Profiler.StartPreciseCoverageResponse | Protocol.Profiler.StopResponse | Protocol.Profiler.TakePreciseCoverageResponse | Protocol.Runtime.AwaitPromiseResponse | Protocol.Runtime.CallFunctionOnResponse | Protocol.Runtime.CompileScriptResponse | Protocol.Runtime.EvaluateResponse | Protocol.Runtime.GetIsolateIdResponse | Protocol.Runtime.GetHeapUsageResponse | Protocol.Runtime.GetPropertiesResponse | Protocol.Runtime.GlobalLexicalScopeNamesResponse | Protocol.Runtime.QueryObjectsResponse | Protocol.Runtime.RunScriptResponse | Protocol.Runtime.GetExceptionDetailsResponse | Protocol.Schema.GetDomainsResponse | Protocol.Accessibility.GetPartialAXTreeResponse | Protocol.Accessibility.GetFullAXTreeResponse | Protocol.Accessibility.GetRootAXNodeResponse | Protocol.Accessibility.GetAXNodeAndAncestorsResponse | Protocol.Accessibility.GetChildAXNodesResponse | Protocol.Accessibility.QueryAXTreeResponse | Protocol.Animation.GetCurrentTimeResponse | Protocol.Animation.GetPlaybackRateResponse | Protocol.Animation.ResolveAnimationResponse | Protocol.Audits.GetEncodedResponseResponse | Protocol.Browser.GetVersionResponse | Protocol.Browser.GetBrowserCommandLineResponse | Protocol.Browser.GetHistogramsResponse | Protocol.Browser.GetHistogramResponse | Protocol.Browser.GetWindowBoundsResponse | Protocol.Browser.GetWindowForTargetResponse | Protocol.CSS.AddRuleResponse | Protocol.CSS.CollectClassNamesResponse | Protocol.CSS.CreateStyleSheetResponse | Protocol.CSS.GetBackgroundColorsResponse | Protocol.CSS.GetComputedStyleForNodeResponse | Protocol.CSS.GetInlineStylesForNodeResponse | Protocol.CSS.GetMatchedStylesForNodeResponse | Protocol.CSS.GetMediaQueriesResponse | Protocol.CSS.GetPlatformFontsForNodeResponse | Protocol.CSS.GetStyleSheetTextResponse | Protocol.CSS.GetLayersForNodeResponse | Protocol.CSS.TakeComputedStyleUpdatesResponse | Protocol.CSS.SetKeyframeKeyResponse | Protocol.CSS.SetMediaTextResponse | Protocol.CSS.SetContainerQueryTextResponse | Protocol.CSS.SetSupportsTextResponse | Protocol.CSS.SetScopeTextResponse | Protocol.CSS.SetRuleSelectorResponse | Protocol.CSS.SetStyleSheetTextResponse | Protocol.CSS.SetStyleTextsResponse | Protocol.CSS.StopRuleUsageTrackingResponse | Protocol.CSS.TakeCoverageDeltaResponse | Protocol.CacheStorage.RequestCacheNamesResponse | Protocol.CacheStorage.RequestCachedResponseResponse | Protocol.CacheStorage.RequestEntriesResponse | Protocol.DOM.CollectClassNamesFromSubtreeResponse | Protocol.DOM.CopyToResponse | Protocol.DOM.DescribeNodeResponse | Protocol.DOM.GetAttributesResponse | Protocol.DOM.GetBoxModelResponse | Protocol.DOM.GetContentQuadsResponse | Protocol.DOM.GetDocumentResponse | Protocol.DOM.GetFlattenedDocumentResponse | Protocol.DOM.GetNodesForSubtreeByStyleResponse | Protocol.DOM.GetNodeForLocationResponse | Protocol.DOM.GetOuterHTMLResponse | Protocol.DOM.GetRelayoutBoundaryResponse | Protocol.DOM.GetSearchResultsResponse | Protocol.DOM.MoveToResponse | Protocol.DOM.PerformSearchResponse | Protocol.DOM.PushNodeByPathToFrontendResponse | Protocol.DOM.PushNodesByBackendIdsToFrontendResponse | Protocol.DOM.QuerySelectorResponse | Protocol.DOM.QuerySelectorAllResponse | Protocol.DOM.GetTopLayerElementsResponse | Protocol.DOM.RequestNodeResponse | Protocol.DOM.ResolveNodeResponse | Protocol.DOM.GetNodeStackTracesResponse | Protocol.DOM.GetFileInfoResponse | Protocol.DOM.SetNodeNameResponse | Protocol.DOM.GetFrameOwnerResponse | Protocol.DOM.GetContainerForNodeResponse | Protocol.DOM.GetQueryingDescendantsForContainerResponse | Protocol.DOMDebugger.GetEventListenersResponse | Protocol.DOMSnapshot.GetSnapshotResponse | Protocol.DOMSnapshot.CaptureSnapshotResponse | Protocol.DOMStorage.GetDOMStorageItemsResponse | Protocol.Database.ExecuteSQLResponse | Protocol.Database.GetDatabaseTableNamesResponse | Protocol.Emulation.CanEmulateResponse | Protocol.Emulation.SetVirtualTimePolicyResponse | Protocol.HeadlessExperimental.BeginFrameResponse | Protocol.IO.ReadResponse | Protocol.IO.ResolveBlobResponse | Protocol.IndexedDB.RequestDataResponse | Protocol.IndexedDB.GetMetadataResponse | Protocol.IndexedDB.RequestDatabaseResponse | Protocol.IndexedDB.RequestDatabaseNamesResponse | Protocol.LayerTree.CompositingReasonsResponse | Protocol.LayerTree.LoadSnapshotResponse | Protocol.LayerTree.MakeSnapshotResponse | Protocol.LayerTree.ProfileSnapshotResponse | Protocol.LayerTree.ReplaySnapshotResponse | Protocol.LayerTree.SnapshotCommandLogResponse | Protocol.Memory.GetDOMCountersResponse | Protocol.Memory.GetAllTimeSamplingProfileResponse | Protocol.Memory.GetBrowserSamplingProfileResponse | Protocol.Memory.GetSamplingProfileResponse | Protocol.Network.CanClearBrowserCacheResponse | Protocol.Network.CanClearBrowserCookiesResponse | Protocol.Network.CanEmulateNetworkConditionsResponse | Protocol.Network.GetAllCookiesResponse | Protocol.Network.GetCertificateResponse | Protocol.Network.GetCookiesResponse | Protocol.Network.GetResponseBodyResponse | Protocol.Network.GetRequestPostDataResponse | Protocol.Network.GetResponseBodyForInterceptionResponse | Protocol.Network.TakeResponseBodyForInterceptionAsStreamResponse | Protocol.Network.SearchInResponseBodyResponse | Protocol.Network.SetCookieResponse | Protocol.Network.GetSecurityIsolationStatusResponse | Protocol.Network.LoadNetworkResourceResponse | Protocol.Overlay.GetHighlightObjectForTestResponse | Protocol.Overlay.GetGridHighlightObjectsForTestResponse | Protocol.Overlay.GetSourceOrderHighlightObjectForTestResponse | Protocol.Page.AddScriptToEvaluateOnLoadResponse | Protocol.Page.AddScriptToEvaluateOnNewDocumentResponse | Protocol.Page.CaptureScreenshotResponse | Protocol.Page.CaptureSnapshotResponse | Protocol.Page.CreateIsolatedWorldResponse | Protocol.Page.GetAppManifestResponse | Protocol.Page.GetInstallabilityErrorsResponse | Protocol.Page.GetManifestIconsResponse | Protocol.Page.GetAppIdResponse | Protocol.Page.GetAdScriptIdResponse | Protocol.Page.GetCookiesResponse | Protocol.Page.GetFrameTreeResponse | Protocol.Page.GetLayoutMetricsResponse | Protocol.Page.GetNavigationHistoryResponse | Protocol.Page.GetResourceContentResponse | Protocol.Page.GetResourceTreeResponse | Protocol.Page.NavigateResponse | Protocol.Page.PrintToPDFResponse | Protocol.Page.SearchInResourceResponse | Protocol.Page.GetPermissionsPolicyStateResponse | Protocol.Page.GetOriginTrialsResponse | Protocol.Performance.GetMetricsResponse | Protocol.Storage.GetStorageKeyForFrameResponse | Protocol.Storage.GetCookiesResponse | Protocol.Storage.GetUsageAndQuotaResponse | Protocol.Storage.GetTrustTokensResponse | Protocol.Storage.ClearTrustTokensResponse | Protocol.Storage.GetInterestGroupDetailsResponse | Protocol.Storage.GetSharedStorageMetadataResponse | Protocol.Storage.GetSharedStorageEntriesResponse | Protocol.SystemInfo.GetInfoResponse | Protocol.SystemInfo.GetFeatureStateResponse | Protocol.SystemInfo.GetProcessInfoResponse | Protocol.Target.AttachToTargetResponse | Protocol.Target.AttachToBrowserTargetResponse | Protocol.Target.CloseTargetResponse | Protocol.Target.CreateBrowserContextResponse | Protocol.Target.GetBrowserContextsResponse | Protocol.Target.CreateTargetResponse | Protocol.Target.GetTargetInfoResponse | Protocol.Target.GetTargetsResponse | Protocol.Tracing.GetCategoriesResponse | Protocol.Tracing.RequestMemoryDumpResponse | Protocol.Fetch.GetResponseBodyResponse | Protocol.Fetch.TakeResponseBodyAsStreamResponse | Protocol.WebAudio.GetRealtimeDataResponse | Protocol.WebAuthn.AddVirtualAuthenticatorResponse | Protocol.WebAuthn.GetCredentialResponse | Protocol.WebAuthn.GetCredentialsResponse;
        cdpSession: any;
    }>;
    process_cdp_getSession(params: CDP.GetSessionParams): {
        result: {
            cdpSession: null;
        };
    } | {
        result: {
            cdpSession: string;
        };
    };
}
