"use strict";
/**
 * Copyright 2022 Google LLC.
 * Copyright (c) Microsoft Corporation.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
Object.defineProperty(exports, "__esModule", { value: true });
const chai_1 = require("chai");
const idWrapper_js_1 = require("./idWrapper.js");
describe('IdWrapper', () => {
    it('wraps value with unique id', () => {
        const wrapper1 = new idWrapper_js_1.IdWrapper();
        const wrapper2 = new idWrapper_js_1.IdWrapper();
        (0, chai_1.expect)(wrapper1.id).to.equal(1);
        (0, chai_1.expect)(wrapper2.id).to.equal(2);
    });
});
//# sourceMappingURL=idWrapper.spec.js.map