'use strict';

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.default = defaultChunkParser;
var entryDelimiter = '\n';

// The defaultChunkParser expects the response from the server to consist of new-line
// delimited JSON, eg:
//
//  { "chunk": "#1", "data": "Hello" }\n
//  { "chunk": "#2", "data": "World" }
//
// It will correctly handle the case where a chunk is emitted by the server across
// delimiter boundaries.
function defaultChunkParser(bytes) {
  var state = arguments.length <= 1 || arguments[1] === undefined ? {} : arguments[1];
  var flush = arguments.length <= 2 || arguments[2] === undefined ? false : arguments[2];

  if (!state.textDecoder) {
    state.textDecoder = new TextDecoder();
  }
  var textDecoder = state.textDecoder;
  var chunkStr = textDecoder.decode(bytes, { stream: !flush });
  var jsonLiterals = chunkStr.split(entryDelimiter);
  if (state.trailer) {
    jsonLiterals[0] = '' + state.trailer + jsonLiterals[0];
    state.trailer = '';
  }

  // Is this a complete message?  If not; push the trailing (incomplete) string 
  // into the state. 
  if (!flush && !hasSuffix(chunkStr, entryDelimiter)) {
    state.trailer = jsonLiterals.pop();
  }

  var jsonObjects = jsonLiterals.filter(function (v) {
    return v.trim() !== '';
  }).map(function (v) {
    return JSON.parse(v);
  });

  return [jsonObjects, state];
}

function hasSuffix(s, suffix) {
  return s.substr(s.length - suffix.length) === suffix;
}