'use strict';

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.default = defaultTransportFactory;

var _fetch = require('./impl/fetch');

var _fetch2 = _interopRequireDefault(_fetch);

var _mozXhr = require('./impl/mozXhr');

var _mozXhr2 = _interopRequireDefault(_mozXhr);

var _xhr = require('./impl/xhr');

var _xhr2 = _interopRequireDefault(_xhr);

function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { default: obj }; }

var selected = null;

function defaultTransportFactory() {
  var userAgent = navigator.userAgent.toLowerCase();

  if (!selected) {
    if (userAgent.indexOf("chrome") !== -1) {
      selected = _fetch2.default;
    } else if (userAgent.indexOf('firefox') !== -1) {
      selected = _mozXhr2.default;
    } else {
      selected = _xhr2.default;
    }
  }
  return selected;
}