'use strict';

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.READABLE_BYTE_STREAM = undefined;
exports.default = fetchRequest;

var _util = require('../util');

var READABLE_BYTE_STREAM = exports.READABLE_BYTE_STREAM = 'readable-byte-stream';

function fetchRequest(options) {
  var onRawChunk = options.onRawChunk;
  var onRawComplete = options.onRawComplete;
  var method = options.method;
  var body = options.body;
  var credentials = options.credentials;

  var headers = marshallHeaders(options.headers);

  function pump(reader, res) {
    return reader.read().then(function (result) {
      if (result.done) {
        setTimeout(function () {
          onRawComplete({
            statusCode: res.status,
            transport: READABLE_BYTE_STREAM,
            raw: res
          });
        });
        return;
      }
      onRawChunk(result.value);
      return pump(reader, res);
    });
  }

  function onError(err) {
    setTimeout(function () {
      options.onRawComplete({
        statusCode: 0,
        transport: READABLE_BYTE_STREAM,
        raw: err
      });
    });
  }

  fetch(options.url, { headers: headers, method: method, body: body, credentials: credentials }).then(function (res) {
    return pump(res.body.getReader(), res);
  }).catch(onError);
}

function marshallHeaders(v) {
  if (v instanceof Headers) {
    return v;
  } else if ((0, _util.isObject)(v)) {
    return new Headers(v);
  }
}