'use strict';

Object.defineProperty(exports, "__esModule", {
  value: true
});

var _slicedToArray = function () { function sliceIterator(arr, i) { var _arr = []; var _n = true; var _d = false; var _e = undefined; try { for (var _i = arr[Symbol.iterator](), _s; !(_n = (_s = _i.next()).done); _n = true) { _arr.push(_s.value); if (i && _arr.length === i) break; } } catch (err) { _d = true; _e = err; } finally { try { if (!_n && _i["return"]) _i["return"](); } finally { if (_d) throw _e; } } return _arr; } return function (arr, i) { if (Array.isArray(arr)) { return arr; } else if (Symbol.iterator in Object(arr)) { return sliceIterator(arr, i); } else { throw new TypeError("Invalid attempt to destructure non-iterable instance"); } }; }();

exports.default = chunkedRequest;

var _util = require('./util');

var _defaultTransportFactory = require('./defaultTransportFactory');

var _defaultTransportFactory2 = _interopRequireDefault(_defaultTransportFactory);

var _defaultChunkParser = require('./defaultChunkParser');

var _defaultChunkParser2 = _interopRequireDefault(_defaultChunkParser);

function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { default: obj }; }

// chunkedRequest will make a network request to the URL specified in `options.url`
// passing chunks of data extracted by the optional `options.chunkParser` to the
// optional `options.onChunk` callback.  When the request has completed the optional
// `options.onComplete` callback will be invoked.
function chunkedRequest(options) {
  validateOptions(options);

  var url = options.url;
  var headers = options.headers;
  var _options$method = options.method;
  var method = _options$method === undefined ? 'GET' : _options$method;
  var body = options.body;
  var _options$credentials = options.credentials;
  var credentials = _options$credentials === undefined ? 'same-origin' : _options$credentials;
  var _options$onComplete = options.onComplete;
  var onComplete = _options$onComplete === undefined ? _util.noop : _options$onComplete;
  var _options$onChunk = options.onChunk;
  var onChunk = _options$onChunk === undefined ? _util.noop : _options$onChunk;
  var _options$chunkParser = options.chunkParser;
  var chunkParser = _options$chunkParser === undefined ? _defaultChunkParser2.default : _options$chunkParser;

  // parserState can be utilised by the chunkParser to hold on to state; the
  // defaultChunkParser uses it to keep track of any trailing text the last
  // delimiter in the chunk.  There is no contract for parserState.

  var parserState = void 0;

  function processRawChunk(chunkBytes) {
    var flush = arguments.length <= 1 || arguments[1] === undefined ? false : arguments[1];

    var parsedChunks = null;
    var parseError = null;

    try {
      var _chunkParser = chunkParser(chunkBytes, parserState, flush);

      var _chunkParser2 = _slicedToArray(_chunkParser, 2);

      parsedChunks = _chunkParser2[0];
      parserState = _chunkParser2[1];
    } catch (e) {
      parseError = e;
      parseError.chunkBytes = chunkBytes;
      parseError.parserState = parserState;
    } finally {
      if (parseError || parsedChunks && parsedChunks.length > 0) {
        onChunk(parseError, parsedChunks);
      }
    }
  }

  function processRawComplete(rawComplete) {
    if (parserState) {
      // Flush the parser to process any remaining state.
      processRawChunk(new Uint8Array(0), true);
    }
    onComplete(rawComplete);
  }

  var transport = options.transport;
  if (!transport) {
    transport = chunkedRequest.transportFactory();
  }

  transport({
    url: url,
    headers: headers,
    method: method,
    body: body,
    credentials: credentials,
    onRawChunk: processRawChunk,
    onRawComplete: processRawComplete
  });
}

// override this function to delegate to an alternative transport function selection
// strategy; useful when testing.
chunkedRequest.transportFactory = _defaultTransportFactory2.default;

function validateOptions(o) {
  // Required.
  if (!(0, _util.isObject)(o)) throw new Error('Invalid options argument');
  if (typeof o.url !== 'string' || o.length === 0) throw new Error('Invalid options.url value');

  // Optional.
  if (o.onComplete && typeof o.onComplete !== 'function') throw new Error('Invalid options.onComplete value');
  if (o.onChunk && typeof o.onChunk !== 'function') throw new Error('Invalid options.onChunk value');
  if (o.chunkParser && typeof o.chunkParser !== 'function') throw new Error('Invalid options.chunkParser value');
}