import { TreeModel } from './tree.model';
import { TreeOptions } from './tree-options.model';
import { ITreeNode } from '../defs/api';
export declare class TreeNode implements ITreeNode {
    data: any;
    parent: TreeNode;
    treeModel: TreeModel;
    private handler;
    get isHidden(): boolean;
    get isExpanded(): boolean;
    get isActive(): boolean;
    get isFocused(): boolean;
    get isSelected(): boolean;
    get isAllSelected(): boolean;
    get isPartiallySelected(): boolean;
    children: TreeNode[];
    index: number;
    position: number;
    height: number;
    get level(): number;
    get path(): string[];
    get elementRef(): any;
    private _originalNode;
    get originalNode(): any;
    constructor(data: any, parent: TreeNode, treeModel: TreeModel, index: number);
    get hasChildren(): boolean;
    get isCollapsed(): boolean;
    get isLeaf(): boolean;
    get isRoot(): boolean;
    get realParent(): TreeNode;
    get options(): TreeOptions;
    fireEvent(event: any): void;
    get displayField(): any;
    get id(): any;
    set id(value: any);
    getField(key: any): any;
    setField(key: any, value: any): void;
    _findAdjacentSibling(steps: any, skipHidden?: boolean): any;
    findNextSibling(skipHidden?: boolean): any;
    findPreviousSibling(skipHidden?: boolean): any;
    getVisibleChildren(): TreeNode[];
    get visibleChildren(): TreeNode[];
    getFirstChild(skipHidden?: boolean): TreeNode;
    getLastChild(skipHidden?: boolean): TreeNode;
    findNextNode(goInside?: boolean, skipHidden?: boolean): any;
    findPreviousNode(skipHidden?: boolean): any;
    _getLastOpenDescendant(skipHidden?: boolean): any;
    private _getParentsChildren;
    private getIndexInParent;
    isDescendantOf(node: TreeNode): any;
    getNodePadding(): string;
    getClass(): string;
    onDrop($event: any): void;
    allowDrop: (element: any, $event?: any) => boolean;
    allowDragoverStyling: () => boolean;
    allowDrag(): boolean;
    loadNodeChildren(): Promise<void>;
    expand(): this;
    collapse(): this;
    doForAll(fn: (node: ITreeNode) => any): void;
    expandAll(): void;
    collapseAll(): void;
    ensureVisible(): this;
    toggleExpanded(): this;
    setIsExpanded(value: any): this;
    autoLoadChildren(): void;
    dispose(): void;
    setIsActive(value: any, multi?: boolean): this;
    isSelectable(): boolean;
    setIsSelected(value: any): this;
    toggleSelected(): this;
    toggleActivated(multi?: boolean): this;
    setActiveAndVisible(multi?: boolean): this;
    scrollIntoView(force?: boolean): void;
    focus(scroll?: boolean): this;
    blur(): this;
    setIsHidden(value: any): void;
    hide(): void;
    show(): void;
    mouseAction(actionName: string, $event: any, data?: any): void;
    getSelfHeight(): number;
    _initChildren(): void;
}
