Changelog
=========

## [38.1.1](https://github.com/ckeditor/ckeditor5/compare/v38.1.0...v38.1.1) (2023-07-10)

### Release highlights

Due to a vulnerability issue in the `protobufjs` package ([CVE-2023-36665](https://github.com/advisories/GHSA-h755-8qp9-cq85)) used by packages to offer [real-time collaboration](https://ckeditor.com/docs/ckeditor5/latest/features/collaboration/collaboration.html) services, we strongly advise updating to the latest CKEditor 5 version if your integration includes one of the following features:

* [Real-time collaborative comments](https://ckeditor.com/docs/ckeditor5/latest/features/collaboration/comments/comments.html).
* [Real-time collaborative editing](https://ckeditor.com/docs/ckeditor5/latest/features/collaboration/real-time-collaboration/real-time-collaboration.html).
* [Real-time collaborative revision history](https://ckeditor.com/docs/ckeditor5/latest/features/collaboration/revision-history/revision-history.html).
* [Real-time collaborative track changes](https://ckeditor.com/docs/ckeditor5/latest/features/collaboration/track-changes/track-changes.html).


### Released packages

Check out the [Versioning policy](https://ckeditor.com/docs/ckeditor5/latest/framework/guides/support/versioning-policy.html) guide for more information.

<details>
<summary>Released packages (summary)</summary>

Other releases:

* [@ckeditor/ckeditor5-adapter-ckfinder](https://www.npmjs.com/package/@ckeditor/ckeditor5-adapter-ckfinder): v38.1.0 => v38.1.1
* [@ckeditor/ckeditor5-alignment](https://www.npmjs.com/package/@ckeditor/ckeditor5-alignment): v38.1.0 => v38.1.1
* [@ckeditor/ckeditor5-autoformat](https://www.npmjs.com/package/@ckeditor/ckeditor5-autoformat): v38.1.0 => v38.1.1
* [@ckeditor/ckeditor5-autosave](https://www.npmjs.com/package/@ckeditor/ckeditor5-autosave): v38.1.0 => v38.1.1
* [@ckeditor/ckeditor5-basic-styles](https://www.npmjs.com/package/@ckeditor/ckeditor5-basic-styles): v38.1.0 => v38.1.1
* [@ckeditor/ckeditor5-block-quote](https://www.npmjs.com/package/@ckeditor/ckeditor5-block-quote): v38.1.0 => v38.1.1
* [@ckeditor/ckeditor5-build-balloon](https://www.npmjs.com/package/@ckeditor/ckeditor5-build-balloon): v38.1.0 => v38.1.1
* [@ckeditor/ckeditor5-build-balloon-block](https://www.npmjs.com/package/@ckeditor/ckeditor5-build-balloon-block): v38.1.0 => v38.1.1
* [@ckeditor/ckeditor5-build-classic](https://www.npmjs.com/package/@ckeditor/ckeditor5-build-classic): v38.1.0 => v38.1.1
* [@ckeditor/ckeditor5-build-decoupled-document](https://www.npmjs.com/package/@ckeditor/ckeditor5-build-decoupled-document): v38.1.0 => v38.1.1
* [@ckeditor/ckeditor5-build-inline](https://www.npmjs.com/package/@ckeditor/ckeditor5-build-inline): v38.1.0 => v38.1.1
* [@ckeditor/ckeditor5-build-multi-root](https://www.npmjs.com/package/@ckeditor/ckeditor5-build-multi-root): v38.1.0 => v38.1.1
* [@ckeditor/ckeditor5-ckbox](https://www.npmjs.com/package/@ckeditor/ckeditor5-ckbox): v38.1.0 => v38.1.1
* [@ckeditor/ckeditor5-ckfinder](https://www.npmjs.com/package/@ckeditor/ckeditor5-ckfinder): v38.1.0 => v38.1.1
* [@ckeditor/ckeditor5-clipboard](https://www.npmjs.com/package/@ckeditor/ckeditor5-clipboard): v38.1.0 => v38.1.1
* [@ckeditor/ckeditor5-cloud-services](https://www.npmjs.com/package/@ckeditor/ckeditor5-cloud-services): v38.1.0 => v38.1.1
* [@ckeditor/ckeditor5-code-block](https://www.npmjs.com/package/@ckeditor/ckeditor5-code-block): v38.1.0 => v38.1.1
* [@ckeditor/ckeditor5-collaboration-core](https://www.npmjs.com/package/@ckeditor/ckeditor5-collaboration-core): v38.1.0 => v38.1.1
* [@ckeditor/ckeditor5-comments](https://www.npmjs.com/package/@ckeditor/ckeditor5-comments): v38.1.0 => v38.1.1
* [@ckeditor/ckeditor5-core](https://www.npmjs.com/package/@ckeditor/ckeditor5-core): v38.1.0 => v38.1.1
* [@ckeditor/ckeditor5-document-outline](https://www.npmjs.com/package/@ckeditor/ckeditor5-document-outline): v38.1.0 => v38.1.1
* [@ckeditor/ckeditor5-easy-image](https://www.npmjs.com/package/@ckeditor/ckeditor5-easy-image): v38.1.0 => v38.1.1
* [@ckeditor/ckeditor5-editor-balloon](https://www.npmjs.com/package/@ckeditor/ckeditor5-editor-balloon): v38.1.0 => v38.1.1
* [@ckeditor/ckeditor5-editor-classic](https://www.npmjs.com/package/@ckeditor/ckeditor5-editor-classic): v38.1.0 => v38.1.1
* [@ckeditor/ckeditor5-editor-decoupled](https://www.npmjs.com/package/@ckeditor/ckeditor5-editor-decoupled): v38.1.0 => v38.1.1
* [@ckeditor/ckeditor5-editor-inline](https://www.npmjs.com/package/@ckeditor/ckeditor5-editor-inline): v38.1.0 => v38.1.1
* [@ckeditor/ckeditor5-editor-multi-root](https://www.npmjs.com/package/@ckeditor/ckeditor5-editor-multi-root): v38.1.0 => v38.1.1
* [@ckeditor/ckeditor5-engine](https://www.npmjs.com/package/@ckeditor/ckeditor5-engine): v38.1.0 => v38.1.1
* [@ckeditor/ckeditor5-enter](https://www.npmjs.com/package/@ckeditor/ckeditor5-enter): v38.1.0 => v38.1.1
* [@ckeditor/ckeditor5-essentials](https://www.npmjs.com/package/@ckeditor/ckeditor5-essentials): v38.1.0 => v38.1.1
* [@ckeditor/ckeditor5-export-pdf](https://www.npmjs.com/package/@ckeditor/ckeditor5-export-pdf): v38.1.0 => v38.1.1
* [@ckeditor/ckeditor5-export-word](https://www.npmjs.com/package/@ckeditor/ckeditor5-export-word): v38.1.0 => v38.1.1
* [@ckeditor/ckeditor5-find-and-replace](https://www.npmjs.com/package/@ckeditor/ckeditor5-find-and-replace): v38.1.0 => v38.1.1
* [@ckeditor/ckeditor5-font](https://www.npmjs.com/package/@ckeditor/ckeditor5-font): v38.1.0 => v38.1.1
* [@ckeditor/ckeditor5-format-painter](https://www.npmjs.com/package/@ckeditor/ckeditor5-format-painter): v38.1.0 => v38.1.1
* [@ckeditor/ckeditor5-heading](https://www.npmjs.com/package/@ckeditor/ckeditor5-heading): v38.1.0 => v38.1.1
* [@ckeditor/ckeditor5-highlight](https://www.npmjs.com/package/@ckeditor/ckeditor5-highlight): v38.1.0 => v38.1.1
* [@ckeditor/ckeditor5-horizontal-line](https://www.npmjs.com/package/@ckeditor/ckeditor5-horizontal-line): v38.1.0 => v38.1.1
* [@ckeditor/ckeditor5-html-embed](https://www.npmjs.com/package/@ckeditor/ckeditor5-html-embed): v38.1.0 => v38.1.1
* [@ckeditor/ckeditor5-html-support](https://www.npmjs.com/package/@ckeditor/ckeditor5-html-support): v38.1.0 => v38.1.1
* [@ckeditor/ckeditor5-image](https://www.npmjs.com/package/@ckeditor/ckeditor5-image): v38.1.0 => v38.1.1
* [@ckeditor/ckeditor5-import-word](https://www.npmjs.com/package/@ckeditor/ckeditor5-import-word): v38.1.0 => v38.1.1
* [@ckeditor/ckeditor5-indent](https://www.npmjs.com/package/@ckeditor/ckeditor5-indent): v38.1.0 => v38.1.1
* [@ckeditor/ckeditor5-language](https://www.npmjs.com/package/@ckeditor/ckeditor5-language): v38.1.0 => v38.1.1
* [@ckeditor/ckeditor5-link](https://www.npmjs.com/package/@ckeditor/ckeditor5-link): v38.1.0 => v38.1.1
* [@ckeditor/ckeditor5-list](https://www.npmjs.com/package/@ckeditor/ckeditor5-list): v38.1.0 => v38.1.1
* [@ckeditor/ckeditor5-markdown-gfm](https://www.npmjs.com/package/@ckeditor/ckeditor5-markdown-gfm): v38.1.0 => v38.1.1
* [@ckeditor/ckeditor5-media-embed](https://www.npmjs.com/package/@ckeditor/ckeditor5-media-embed): v38.1.0 => v38.1.1
* [@ckeditor/ckeditor5-mention](https://www.npmjs.com/package/@ckeditor/ckeditor5-mention): v38.1.0 => v38.1.1
* [@ckeditor/ckeditor5-minimap](https://www.npmjs.com/package/@ckeditor/ckeditor5-minimap): v38.1.0 => v38.1.1
* [@ckeditor/ckeditor5-operations-compressor](https://www.npmjs.com/package/@ckeditor/ckeditor5-operations-compressor): v38.1.0 => v38.1.1
* [@ckeditor/ckeditor5-page-break](https://www.npmjs.com/package/@ckeditor/ckeditor5-page-break): v38.1.0 => v38.1.1
* [@ckeditor/ckeditor5-pagination](https://www.npmjs.com/package/@ckeditor/ckeditor5-pagination): v38.1.0 => v38.1.1
* [@ckeditor/ckeditor5-paragraph](https://www.npmjs.com/package/@ckeditor/ckeditor5-paragraph): v38.1.0 => v38.1.1
* [@ckeditor/ckeditor5-paste-from-office](https://www.npmjs.com/package/@ckeditor/ckeditor5-paste-from-office): v38.1.0 => v38.1.1
* [@ckeditor/ckeditor5-real-time-collaboration](https://www.npmjs.com/package/@ckeditor/ckeditor5-real-time-collaboration): v38.1.0 => v38.1.1
* [@ckeditor/ckeditor5-remove-format](https://www.npmjs.com/package/@ckeditor/ckeditor5-remove-format): v38.1.0 => v38.1.1
* [@ckeditor/ckeditor5-restricted-editing](https://www.npmjs.com/package/@ckeditor/ckeditor5-restricted-editing): v38.1.0 => v38.1.1
* [@ckeditor/ckeditor5-revision-history](https://www.npmjs.com/package/@ckeditor/ckeditor5-revision-history): v38.1.0 => v38.1.1
* [@ckeditor/ckeditor5-select-all](https://www.npmjs.com/package/@ckeditor/ckeditor5-select-all): v38.1.0 => v38.1.1
* [@ckeditor/ckeditor5-show-blocks](https://www.npmjs.com/package/@ckeditor/ckeditor5-show-blocks): v38.1.0 => v38.1.1
* [@ckeditor/ckeditor5-slash-command](https://www.npmjs.com/package/@ckeditor/ckeditor5-slash-command): v38.1.0 => v38.1.1
* [@ckeditor/ckeditor5-source-editing](https://www.npmjs.com/package/@ckeditor/ckeditor5-source-editing): v38.1.0 => v38.1.1
* [@ckeditor/ckeditor5-special-characters](https://www.npmjs.com/package/@ckeditor/ckeditor5-special-characters): v38.1.0 => v38.1.1
* [@ckeditor/ckeditor5-style](https://www.npmjs.com/package/@ckeditor/ckeditor5-style): v38.1.0 => v38.1.1
* [@ckeditor/ckeditor5-table](https://www.npmjs.com/package/@ckeditor/ckeditor5-table): v38.1.0 => v38.1.1
* [@ckeditor/ckeditor5-template](https://www.npmjs.com/package/@ckeditor/ckeditor5-template): v38.1.0 => v38.1.1
* [@ckeditor/ckeditor5-theme-lark](https://www.npmjs.com/package/@ckeditor/ckeditor5-theme-lark): v38.1.0 => v38.1.1
* [@ckeditor/ckeditor5-track-changes](https://www.npmjs.com/package/@ckeditor/ckeditor5-track-changes): v38.1.0 => v38.1.1
* [@ckeditor/ckeditor5-typing](https://www.npmjs.com/package/@ckeditor/ckeditor5-typing): v38.1.0 => v38.1.1
* [@ckeditor/ckeditor5-ui](https://www.npmjs.com/package/@ckeditor/ckeditor5-ui): v38.1.0 => v38.1.1
* [@ckeditor/ckeditor5-undo](https://www.npmjs.com/package/@ckeditor/ckeditor5-undo): v38.1.0 => v38.1.1
* [@ckeditor/ckeditor5-upload](https://www.npmjs.com/package/@ckeditor/ckeditor5-upload): v38.1.0 => v38.1.1
* [@ckeditor/ckeditor5-utils](https://www.npmjs.com/package/@ckeditor/ckeditor5-utils): v38.1.0 => v38.1.1
* [@ckeditor/ckeditor5-watchdog](https://www.npmjs.com/package/@ckeditor/ckeditor5-watchdog): v38.1.0 => v38.1.1
* [@ckeditor/ckeditor5-widget](https://www.npmjs.com/package/@ckeditor/ckeditor5-widget): v38.1.0 => v38.1.1
* [@ckeditor/ckeditor5-word-count](https://www.npmjs.com/package/@ckeditor/ckeditor5-word-count): v38.1.0 => v38.1.1
* [@ckeditor/letters](https://www.npmjs.com/package/@ckeditor/letters): v38.1.0 => v38.1.1
* [ckeditor5-collaboration](https://www.npmjs.com/package/ckeditor5-collaboration): v38.1.0 => v38.1.1
</details>


## [38.1.0](https://github.com/ckeditor/ckeditor5/compare/v38.0.1...v38.1.0) (2023-06-23)

### Release highlights

* **Show blocks** - The show blocks feature allows the content creators to visualize all block-level elements (except for widgets) by surrounding them with an outline and displaying their element name at the top-left corner of the box.

### MINOR BREAKING CHANGES [ℹ️](https://ckeditor.com/docs/ckeditor5/latest/framework/guides/support/versioning-policy.html#major-and-minor-breaking-changes)

* **[html-support](https://www.npmjs.com/package/@ckeditor/ckeditor5-html-support)**: The `htmlAttributes` model property has been replaced by `html*Attributes`, where the `*` represents the name of the view element. Clients will need to modify their code accordingly by replacing all instances of `htmlAttributes` with `html*Attributes` for the respective view elements.

### Features

* **[export-word](https://www.npmjs.com/package/@ckeditor/ckeditor5-export-word)**: Added support for resolved comment threads in the Export to Word feature.
* **[html-support](https://www.npmjs.com/package/@ckeditor/ckeditor5-html-support)**: Changing a list type now removes styles inherited from the previous type. Closes [#14216](https://github.com/ckeditor/ckeditor5/issues/14216). ([commit](https://github.com/ckeditor/ckeditor5/commit/02822b0f7a945712385e20335dc7666a811ff381))
* **[list](https://www.npmjs.com/package/@ckeditor/ckeditor5-list)**: Added the `AdjacentListsSupport` plugin to separate lists of the same type. Closes [#12738](https://github.com/ckeditor/ckeditor5/issues/12738). ([commit](https://github.com/ckeditor/ckeditor5/commit/574c9345f484ae3cb163a71fbd60d2327b36b3e2))
* **[ui](https://www.npmjs.com/package/@ckeditor/ckeditor5-ui)**: `BodyCollection.bodyCollectionContainer` is now a public property. Closes [#13928](https://github.com/ckeditor/ckeditor5/issues/13928). ([commit](https://github.com/ckeditor/ckeditor5/commit/1f5c8d023876f54993e71c873bc3a7201c2c7cc4))

### Bug fixes

* **[comments](https://www.npmjs.com/package/@ckeditor/ckeditor5-comments)**: The editor should no longer crash after resolving multiple comment threads from multiple editor instances inside one `Context`.
* **[document-outline](https://www.npmjs.com/package/@ckeditor/ckeditor5-document-outline)**: Fixed a randomly failing Table of Contents editing test (before each).
* **[document-outline](https://www.npmjs.com/package/@ckeditor/ckeditor5-document-outline)**: The document outline feature should respect the `config.ui.viewportOffset` configuration.
* **[engine](https://www.npmjs.com/package/@ckeditor/ckeditor5-engine)**: The editor should no longer crash while pressing backspace in an empty editor (in Firefox). Closes [#14411](https://github.com/ckeditor/ckeditor5/issues/14411), [#14050](https://github.com/ckeditor/ckeditor5/issues/14050). ([commit](https://github.com/ckeditor/ckeditor5/commit/402e866e785e7bf97120bc80d469d58b3fe72272))
* **[engine](https://www.npmjs.com/package/@ckeditor/ckeditor5-engine)**: Fixed the shallow view and model TreeWalkers returning elements outside of specified boundaries. ([commit](https://github.com/ckeditor/ckeditor5/commit/c519feb0f4c0129f4fbf492b69440199af9b4312))
* **[engine](https://www.npmjs.com/package/@ckeditor/ckeditor5-engine)**: The CSS shorthand value normalizer should work for values with white spaces. Closes [#14309](https://github.com/ckeditor/ckeditor5/issues/14309). ([commit](https://github.com/ckeditor/ckeditor5/commit/c14cdff9717634bdebabee1d6da068f084bbf5d9))
* **[engine](https://www.npmjs.com/package/@ckeditor/ckeditor5-engine)**: `View#scrollToTheSelection()` should respect the `config.ui.viewportOffset` configuration and consider the geometry of a classic editor's toolbar to assure the caret is always visible to the user. Closes [#13730](https://github.com/ckeditor/ckeditor5/issues/13730). ([commit](https://github.com/ckeditor/ckeditor5/commit/d65f4862e9baad74ab7b7ca5355e290d68f96593))
* **[engine](https://www.npmjs.com/package/@ckeditor/ckeditor5-engine)**: Font attributes are preserved after inserting inline widgets. Closes [#14106](https://github.com/ckeditor/ckeditor5/issues/14106). ([commit](https://github.com/ckeditor/ckeditor5/commit/30c31b6bfa10816cc44287842874b768d6d3ca59))
* **[export-pdf](https://www.npmjs.com/package/@ckeditor/ckeditor5-export-pdf)**: Text will no longer go beyond its cell when columns are resized by the resize handler in exported PDFs. Closes [#3355](https://github.com/ckeditor/ckeditor5/issues/3355). ([commit](https://github.com/ckeditor/ckeditor5/commit/a5908d4dd10faae3fcc37658a3c44fd3026858fa))
* **[font](https://www.npmjs.com/package/@ckeditor/ckeditor5-font)**: The accept button in the color picker will no longer submit forms. Closes [#14361](https://github.com/ckeditor/ckeditor5/issues/14361). ([commit](https://github.com/ckeditor/ckeditor5/commit/eff5ccac9759f97d32ac1c7ff8812c177876cd5b))
* **[html-support](https://www.npmjs.com/package/@ckeditor/ckeditor5-html-support)**: GHS should allow linking of custom elements. Closes [#13803](https://github.com/ckeditor/ckeditor5/issues/13803). ([commit](https://github.com/ckeditor/ckeditor5/commit/371ae0bd057c0120fbf3e1f7581c8390bdf65364))
* **[html-support](https://www.npmjs.com/package/@ckeditor/ckeditor5-html-support)**: Preserve HTML attributes when a list is split or its item is removed. Closes [#14346](https://github.com/ckeditor/ckeditor5/issues/14346) and [#14349](https://github.com/ckeditor/ckeditor5/issues/14349). ([commit](https://github.com/ckeditor/ckeditor5/commit/c519feb0f4c0129f4fbf492b69440199af9b4312))
* **[html-support](https://www.npmjs.com/package/@ckeditor/ckeditor5-html-support)**: Remove unrelated `html*Attributes` from elements. See [#14216](https://github.com/ckeditor/ckeditor5/issues/14216). ([commit](https://github.com/ckeditor/ckeditor5/commit/80daee5bdf4cea27a318f8472d5146e56d680a22))
* **[mention](https://www.npmjs.com/package/@ckeditor/ckeditor5-mention)**: Multiple mentions in the last table cell should not result in a selection error. Closes [#14025](https://github.com/ckeditor/ckeditor5/issues/14025). ([commit](https://github.com/ckeditor/ckeditor5/commit/39c2d9121966d020a3f57caa7d428fb0a0459e0b))
* **[paste-from-office](https://www.npmjs.com/package/@ckeditor/ckeditor5-paste-from-office)**: Remove the `<style>` tag that comes with the table pasted from Google Sheets. Closes [#14131](https://github.com/ckeditor/ckeditor5/issues/14131). ([commit](https://github.com/ckeditor/ckeditor5/commit/8208af13b7d9cbbe4dab1d399e2f9bd7c7601d2d))
* **[paste-from-office](https://www.npmjs.com/package/@ckeditor/ckeditor5-paste-from-office)**: List markers should be displayed correctly after pasting a list from MS Word. Closes [#12361](https://github.com/ckeditor/ckeditor5/issues/12361). ([commit](https://github.com/ckeditor/ckeditor5/commit/066b69b79cf6da80d44148ac6d1af0f07a31766d))
* **[style](https://www.npmjs.com/package/@ckeditor/ckeditor5-style)**: Styles dropdown should allow styling `<div>` elements. Closes [#13341](https://github.com/ckeditor/ckeditor5/issues/13341). ([commit](https://github.com/ckeditor/ckeditor5/commit/4b44f58c8dd280cafaadb10b2d099423fce054b9))
* **[table](https://www.npmjs.com/package/@ckeditor/ckeditor5-table)**: Text will no longer go beyond its cell when columns are resized by resize handler in Firefox. Closes [#14386](https://github.com/ckeditor/ckeditor5/issues/14386). ([commit](https://github.com/ckeditor/ckeditor5/commit/a5908d4dd10faae3fcc37658a3c44fd3026858fa))
* **[track-changes](https://www.npmjs.com/package/@ckeditor/ckeditor5-track-changes)**: Removed an unnecessary request to the token URL when using the `TrackChangesData` plugin.
* **[ui](https://www.npmjs.com/package/@ckeditor/ckeditor5-ui)**: Fixed a styling issue that would cause some toolbar dropdowns to be shrunk. ([commit](https://github.com/ckeditor/ckeditor5/commit/53f0dc2f9d75031113803791e3051b5b9c422560))
* **[ui](https://www.npmjs.com/package/@ckeditor/ckeditor5-ui)**: Fixed the arrow keys behavior in the color picker component. Closes [#14218](https://github.com/ckeditor/ckeditor5/issues/14218). ([commit](https://github.com/ckeditor/ckeditor5/commit/29be557777337dc9f9b44fa120cbeec65f0e6a97))
* **[ui](https://www.npmjs.com/package/@ckeditor/ckeditor5-ui)**: The "Powered by" logo should not shake on the first show. Closes [cksource/ckeditor5-internal#3289](https://github.com/cksource/ckeditor5-internal/issues/3289). ([commit](https://github.com/ckeditor/ckeditor5/commit/48fa3444fe85bc424ddbf5314fbc540c3d4497d7))
* **[ui](https://www.npmjs.com/package/@ckeditor/ckeditor5-ui)**: Fixed the way code exports the `colorPaletteIcon` icon, which could result in a broken build. Closes [#14205](https://github.com/ckeditor/ckeditor5/issues/14205). ([commit](https://github.com/ckeditor/ckeditor5/commit/046e379d4d7c02dfbc4183819b70d6535776c733))
* **[utils](https://www.npmjs.com/package/@ckeditor/ckeditor5-utils)**: `Rect#getVisible()` should not consider ancestors when the target is an element with `position: absolute`. Closes [#14107](https://github.com/ckeditor/ckeditor5/issues/14107). ([commit](https://github.com/ckeditor/ckeditor5/commit/8b1ede7c4ed1b03905e6fbf822248992c0c84821))
* Added multi-root support for: title, HTML comments, table resize, word count and block toolbar. ([commit](https://github.com/ckeditor/ckeditor5/commit/95ef94b2263e82ed570d8b29293e07d4bc89eef4))
* Fixed editor crash that happened when `TrackChangesData` or revision history was used in setup with `Context` if `CloudServices` was set only in the `Context` configuration (and not in the editor configuration).

### Other changes

* **[comments](https://www.npmjs.com/package/@ckeditor/ckeditor5-comments)**: The resolve button will now be disabled instead of hidden when the editor is in read-only mode for better UI consistency.
* **[engine](https://www.npmjs.com/package/@ckeditor/ckeditor5-engine)**: Exports `ViewTreeWalker` from `ckeditor5-engine/src/index.ts`. Closes [#14158](https://github.com/ckeditor/ckeditor5/issues/14158). ([commit](https://github.com/ckeditor/ckeditor5/commit/e72b49a90d39bcca578681f43b338f350238d3f1))
* **[html-support](https://www.npmjs.com/package/@ckeditor/ckeditor5-html-support)**: Changed `htmlAttributes` to `html*Attributes` where `*` represents the name of the view element. See [#14216](https://github.com/ckeditor/ckeditor5/issues/14216). ([commit](https://github.com/ckeditor/ckeditor5/commit/a04cbd3dcb6581916019ad94b9a7f78d5ce4a568))
* **[ui](https://www.npmjs.com/package/@ckeditor/ckeditor5-ui)**: Added a configuration option that forces the "Powered by" logo to show up despite a valid license key being used. Closes [#14235](https://github.com/ckeditor/ckeditor5/issues/14235). ([commit](https://github.com/ckeditor/ckeditor5/commit/b577283c1c1c4f5649864529cf859ba0e03654ab))
* Optimized icons. ([commit](https://github.com/ckeditor/ckeditor5/commit/34ba6c86b560662a209d44c798d1c4372459c7ab))
* Updated translations. ([commit](https://github.com/ckeditor/ckeditor5/commit/2add9a2e521cf19d9651463fa3c5bdfd07c32045), [commit](https://github.com/ckeditor/ckeditor5/commit/9eea4bfeb7ff3807ad17af926a62376855cbc0d2))

### Released packages

Check out the [Versioning policy](https://ckeditor.com/docs/ckeditor5/latest/framework/guides/support/versioning-policy.html) guide for more information.

<details>
<summary>Released packages (summary)</summary>

New packages:

* [@ckeditor/ckeditor5-show-blocks](https://www.npmjs.com/package/@ckeditor/ckeditor5-show-blocks): v38.1.0

Minor releases (contain minor breaking changes):

* [@ckeditor/ckeditor5-html-support](https://www.npmjs.com/package/@ckeditor/ckeditor5-html-support): v38.0.1 => v38.1.0

Releases containing new features:

* [@ckeditor/ckeditor5-list](https://www.npmjs.com/package/@ckeditor/ckeditor5-list): v38.0.1 => v38.1.0
* [@ckeditor/ckeditor5-style](https://www.npmjs.com/package/@ckeditor/ckeditor5-style): v38.0.1 => v38.1.0
* [@ckeditor/ckeditor5-ui](https://www.npmjs.com/package/@ckeditor/ckeditor5-ui): v38.0.1 => v38.1.0

Other releases:

* [@ckeditor/ckeditor5-adapter-ckfinder](https://www.npmjs.com/package/@ckeditor/ckeditor5-adapter-ckfinder): v38.0.1 => v38.1.0
* [@ckeditor/ckeditor5-alignment](https://www.npmjs.com/package/@ckeditor/ckeditor5-alignment): v38.0.1 => v38.1.0
* [@ckeditor/ckeditor5-autoformat](https://www.npmjs.com/package/@ckeditor/ckeditor5-autoformat): v38.0.1 => v38.1.0
* [@ckeditor/ckeditor5-autosave](https://www.npmjs.com/package/@ckeditor/ckeditor5-autosave): v38.0.1 => v38.1.0
* [@ckeditor/ckeditor5-basic-styles](https://www.npmjs.com/package/@ckeditor/ckeditor5-basic-styles): v38.0.1 => v38.1.0
* [@ckeditor/ckeditor5-block-quote](https://www.npmjs.com/package/@ckeditor/ckeditor5-block-quote): v38.0.1 => v38.1.0
* [@ckeditor/ckeditor5-build-balloon](https://www.npmjs.com/package/@ckeditor/ckeditor5-build-balloon): v38.0.1 => v38.1.0
* [@ckeditor/ckeditor5-build-balloon-block](https://www.npmjs.com/package/@ckeditor/ckeditor5-build-balloon-block): v38.0.1 => v38.1.0
* [@ckeditor/ckeditor5-build-classic](https://www.npmjs.com/package/@ckeditor/ckeditor5-build-classic): v38.0.1 => v38.1.0
* [@ckeditor/ckeditor5-build-decoupled-document](https://www.npmjs.com/package/@ckeditor/ckeditor5-build-decoupled-document): v38.0.1 => v38.1.0
* [@ckeditor/ckeditor5-build-inline](https://www.npmjs.com/package/@ckeditor/ckeditor5-build-inline): v38.0.1 => v38.1.0
* [@ckeditor/ckeditor5-build-multi-root](https://www.npmjs.com/package/@ckeditor/ckeditor5-build-multi-root): v38.0.1 => v38.1.0
* [@ckeditor/ckeditor5-ckbox](https://www.npmjs.com/package/@ckeditor/ckeditor5-ckbox): v38.0.1 => v38.1.0
* [@ckeditor/ckeditor5-ckfinder](https://www.npmjs.com/package/@ckeditor/ckeditor5-ckfinder): v38.0.1 => v38.1.0
* [@ckeditor/ckeditor5-clipboard](https://www.npmjs.com/package/@ckeditor/ckeditor5-clipboard): v38.0.1 => v38.1.0
* [@ckeditor/ckeditor5-cloud-services](https://www.npmjs.com/package/@ckeditor/ckeditor5-cloud-services): v38.0.1 => v38.1.0
* [@ckeditor/ckeditor5-code-block](https://www.npmjs.com/package/@ckeditor/ckeditor5-code-block): v38.0.1 => v38.1.0
* [@ckeditor/ckeditor5-collaboration-core](https://www.npmjs.com/package/@ckeditor/ckeditor5-collaboration-core): v38.0.1 => v38.1.0
* [@ckeditor/ckeditor5-comments](https://www.npmjs.com/package/@ckeditor/ckeditor5-comments): v38.0.1 => v38.1.0
* [@ckeditor/ckeditor5-core](https://www.npmjs.com/package/@ckeditor/ckeditor5-core): v38.0.1 => v38.1.0
* [@ckeditor/ckeditor5-document-outline](https://www.npmjs.com/package/@ckeditor/ckeditor5-document-outline): v38.0.1 => v38.1.0
* [@ckeditor/ckeditor5-easy-image](https://www.npmjs.com/package/@ckeditor/ckeditor5-easy-image): v38.0.1 => v38.1.0
* [@ckeditor/ckeditor5-editor-balloon](https://www.npmjs.com/package/@ckeditor/ckeditor5-editor-balloon): v38.0.1 => v38.1.0
* [@ckeditor/ckeditor5-editor-classic](https://www.npmjs.com/package/@ckeditor/ckeditor5-editor-classic): v38.0.1 => v38.1.0
* [@ckeditor/ckeditor5-editor-decoupled](https://www.npmjs.com/package/@ckeditor/ckeditor5-editor-decoupled): v38.0.1 => v38.1.0
* [@ckeditor/ckeditor5-editor-inline](https://www.npmjs.com/package/@ckeditor/ckeditor5-editor-inline): v38.0.1 => v38.1.0
* [@ckeditor/ckeditor5-editor-multi-root](https://www.npmjs.com/package/@ckeditor/ckeditor5-editor-multi-root): v38.0.1 => v38.1.0
* [@ckeditor/ckeditor5-engine](https://www.npmjs.com/package/@ckeditor/ckeditor5-engine): v38.0.1 => v38.1.0
* [@ckeditor/ckeditor5-enter](https://www.npmjs.com/package/@ckeditor/ckeditor5-enter): v38.0.1 => v38.1.0
* [@ckeditor/ckeditor5-essentials](https://www.npmjs.com/package/@ckeditor/ckeditor5-essentials): v38.0.1 => v38.1.0
* [@ckeditor/ckeditor5-export-pdf](https://www.npmjs.com/package/@ckeditor/ckeditor5-export-pdf): v38.0.1 => v38.1.0
* [@ckeditor/ckeditor5-export-word](https://www.npmjs.com/package/@ckeditor/ckeditor5-export-word): v38.0.1 => v38.1.0
* [@ckeditor/ckeditor5-find-and-replace](https://www.npmjs.com/package/@ckeditor/ckeditor5-find-and-replace): v38.0.1 => v38.1.0
* [@ckeditor/ckeditor5-font](https://www.npmjs.com/package/@ckeditor/ckeditor5-font): v38.0.1 => v38.1.0
* [@ckeditor/ckeditor5-format-painter](https://www.npmjs.com/package/@ckeditor/ckeditor5-format-painter): v38.0.1 => v38.1.0
* [@ckeditor/ckeditor5-heading](https://www.npmjs.com/package/@ckeditor/ckeditor5-heading): v38.0.1 => v38.1.0
* [@ckeditor/ckeditor5-highlight](https://www.npmjs.com/package/@ckeditor/ckeditor5-highlight): v38.0.1 => v38.1.0
* [@ckeditor/ckeditor5-horizontal-line](https://www.npmjs.com/package/@ckeditor/ckeditor5-horizontal-line): v38.0.1 => v38.1.0
* [@ckeditor/ckeditor5-html-embed](https://www.npmjs.com/package/@ckeditor/ckeditor5-html-embed): v38.0.1 => v38.1.0
* [@ckeditor/ckeditor5-image](https://www.npmjs.com/package/@ckeditor/ckeditor5-image): v38.0.1 => v38.1.0
* [@ckeditor/ckeditor5-import-word](https://www.npmjs.com/package/@ckeditor/ckeditor5-import-word): v38.0.1 => v38.1.0
* [@ckeditor/ckeditor5-indent](https://www.npmjs.com/package/@ckeditor/ckeditor5-indent): v38.0.1 => v38.1.0
* [@ckeditor/ckeditor5-language](https://www.npmjs.com/package/@ckeditor/ckeditor5-language): v38.0.1 => v38.1.0
* [@ckeditor/ckeditor5-link](https://www.npmjs.com/package/@ckeditor/ckeditor5-link): v38.0.1 => v38.1.0
* [@ckeditor/ckeditor5-markdown-gfm](https://www.npmjs.com/package/@ckeditor/ckeditor5-markdown-gfm): v38.0.1 => v38.1.0
* [@ckeditor/ckeditor5-media-embed](https://www.npmjs.com/package/@ckeditor/ckeditor5-media-embed): v38.0.1 => v38.1.0
* [@ckeditor/ckeditor5-mention](https://www.npmjs.com/package/@ckeditor/ckeditor5-mention): v38.0.1 => v38.1.0
* [@ckeditor/ckeditor5-minimap](https://www.npmjs.com/package/@ckeditor/ckeditor5-minimap): v38.0.1 => v38.1.0
* [@ckeditor/ckeditor5-operations-compressor](https://www.npmjs.com/package/@ckeditor/ckeditor5-operations-compressor): v38.0.1 => v38.1.0
* [@ckeditor/ckeditor5-page-break](https://www.npmjs.com/package/@ckeditor/ckeditor5-page-break): v38.0.1 => v38.1.0
* [@ckeditor/ckeditor5-pagination](https://www.npmjs.com/package/@ckeditor/ckeditor5-pagination): v38.0.1 => v38.1.0
* [@ckeditor/ckeditor5-paragraph](https://www.npmjs.com/package/@ckeditor/ckeditor5-paragraph): v38.0.1 => v38.1.0
* [@ckeditor/ckeditor5-paste-from-office](https://www.npmjs.com/package/@ckeditor/ckeditor5-paste-from-office): v38.0.1 => v38.1.0
* [@ckeditor/ckeditor5-real-time-collaboration](https://www.npmjs.com/package/@ckeditor/ckeditor5-real-time-collaboration): v38.0.1 => v38.1.0
* [@ckeditor/ckeditor5-remove-format](https://www.npmjs.com/package/@ckeditor/ckeditor5-remove-format): v38.0.1 => v38.1.0
* [@ckeditor/ckeditor5-restricted-editing](https://www.npmjs.com/package/@ckeditor/ckeditor5-restricted-editing): v38.0.1 => v38.1.0
* [@ckeditor/ckeditor5-revision-history](https://www.npmjs.com/package/@ckeditor/ckeditor5-revision-history): v38.0.1 => v38.1.0
* [@ckeditor/ckeditor5-select-all](https://www.npmjs.com/package/@ckeditor/ckeditor5-select-all): v38.0.1 => v38.1.0
* [@ckeditor/ckeditor5-slash-command](https://www.npmjs.com/package/@ckeditor/ckeditor5-slash-command): v38.0.1 => v38.1.0
* [@ckeditor/ckeditor5-source-editing](https://www.npmjs.com/package/@ckeditor/ckeditor5-source-editing): v38.0.1 => v38.1.0
* [@ckeditor/ckeditor5-special-characters](https://www.npmjs.com/package/@ckeditor/ckeditor5-special-characters): v38.0.1 => v38.1.0
* [@ckeditor/ckeditor5-table](https://www.npmjs.com/package/@ckeditor/ckeditor5-table): v38.0.1 => v38.1.0
* [@ckeditor/ckeditor5-template](https://www.npmjs.com/package/@ckeditor/ckeditor5-template): v38.0.1 => v38.1.0
* [@ckeditor/ckeditor5-theme-lark](https://www.npmjs.com/package/@ckeditor/ckeditor5-theme-lark): v38.0.1 => v38.1.0
* [@ckeditor/ckeditor5-track-changes](https://www.npmjs.com/package/@ckeditor/ckeditor5-track-changes): v38.0.1 => v38.1.0
* [@ckeditor/ckeditor5-typing](https://www.npmjs.com/package/@ckeditor/ckeditor5-typing): v38.0.1 => v38.1.0
* [@ckeditor/ckeditor5-undo](https://www.npmjs.com/package/@ckeditor/ckeditor5-undo): v38.0.1 => v38.1.0
* [@ckeditor/ckeditor5-upload](https://www.npmjs.com/package/@ckeditor/ckeditor5-upload): v38.0.1 => v38.1.0
* [@ckeditor/ckeditor5-utils](https://www.npmjs.com/package/@ckeditor/ckeditor5-utils): v38.0.1 => v38.1.0
* [@ckeditor/ckeditor5-watchdog](https://www.npmjs.com/package/@ckeditor/ckeditor5-watchdog): v38.0.1 => v38.1.0
* [@ckeditor/ckeditor5-widget](https://www.npmjs.com/package/@ckeditor/ckeditor5-widget): v38.0.1 => v38.1.0
* [@ckeditor/ckeditor5-word-count](https://www.npmjs.com/package/@ckeditor/ckeditor5-word-count): v38.0.1 => v38.1.0
* [@ckeditor/letters](https://www.npmjs.com/package/@ckeditor/letters): v38.0.1 => v38.1.0
* [ckeditor5-collaboration](https://www.npmjs.com/package/ckeditor5-collaboration): v38.0.1 => v38.1.0
</details>


## [38.0.1](https://github.com/ckeditor/ckeditor5/compare/v38.0.0...v38.0.1) (2023-05-23)

### Release highlights

This is a patch release that resolves an incorrect import issue that resulted in a ["Cannot find module" error when using CKEditor 5 in a TypeScript environment](https://github.com/ckeditor/ckeditor5/issues/14205).

Due to that and the [CKEditor 5 versioning policy](https://ckeditor.com/docs/ckeditor5/latest/framework/guides/support/versioning-policy.html), we released all packages once again.

Check out the highlights of the original [v38.0.0 release](https://github.com/ckeditor/ckeditor5/releases/tag/v38.0.0).

### Bug fixes

* **[ui](https://www.npmjs.com/package/@ckeditor/ckeditor5-ui)**: Fixed how the code exports the `colorPaletteIcon` icon, which could result with a broken build. Closes [#14205](https://github.com/ckeditor/ckeditor5/issues/14205). ([commit](https://github.com/ckeditor/ckeditor5/commit/42001f77e84f5d453e81cbcc3ebf69972a90ad8d))

### Released packages

Check out the [Versioning policy](https://ckeditor.com/docs/ckeditor5/latest/framework/guides/support/versioning-policy.html) guide for more information.

<details>
<summary>Released packages (summary)</summary>

Other releases:

* [@ckeditor/ckeditor5-adapter-ckfinder](https://www.npmjs.com/package/@ckeditor/ckeditor5-adapter-ckfinder): v38.0.0 => v38.0.1
* [@ckeditor/ckeditor5-alignment](https://www.npmjs.com/package/@ckeditor/ckeditor5-alignment): v38.0.0 => v38.0.1
* [@ckeditor/ckeditor5-autoformat](https://www.npmjs.com/package/@ckeditor/ckeditor5-autoformat): v38.0.0 => v38.0.1
* [@ckeditor/ckeditor5-autosave](https://www.npmjs.com/package/@ckeditor/ckeditor5-autosave): v38.0.0 => v38.0.1
* [@ckeditor/ckeditor5-basic-styles](https://www.npmjs.com/package/@ckeditor/ckeditor5-basic-styles): v38.0.0 => v38.0.1
* [@ckeditor/ckeditor5-block-quote](https://www.npmjs.com/package/@ckeditor/ckeditor5-block-quote): v38.0.0 => v38.0.1
* [@ckeditor/ckeditor5-build-balloon](https://www.npmjs.com/package/@ckeditor/ckeditor5-build-balloon): v38.0.0 => v38.0.1
* [@ckeditor/ckeditor5-build-balloon-block](https://www.npmjs.com/package/@ckeditor/ckeditor5-build-balloon-block): v38.0.0 => v38.0.1
* [@ckeditor/ckeditor5-build-classic](https://www.npmjs.com/package/@ckeditor/ckeditor5-build-classic): v38.0.0 => v38.0.1
* [@ckeditor/ckeditor5-build-decoupled-document](https://www.npmjs.com/package/@ckeditor/ckeditor5-build-decoupled-document): v38.0.0 => v38.0.1
* [@ckeditor/ckeditor5-build-inline](https://www.npmjs.com/package/@ckeditor/ckeditor5-build-inline): v38.0.0 => v38.0.1
* [@ckeditor/ckeditor5-build-multi-root](https://www.npmjs.com/package/@ckeditor/ckeditor5-build-multi-root): v38.0.0 => v38.0.1
* [@ckeditor/ckeditor5-ckbox](https://www.npmjs.com/package/@ckeditor/ckeditor5-ckbox): v38.0.0 => v38.0.1
* [@ckeditor/ckeditor5-ckfinder](https://www.npmjs.com/package/@ckeditor/ckeditor5-ckfinder): v38.0.0 => v38.0.1
* [@ckeditor/ckeditor5-clipboard](https://www.npmjs.com/package/@ckeditor/ckeditor5-clipboard): v38.0.0 => v38.0.1
* [@ckeditor/ckeditor5-cloud-services](https://www.npmjs.com/package/@ckeditor/ckeditor5-cloud-services): v38.0.0 => v38.0.1
* [@ckeditor/ckeditor5-code-block](https://www.npmjs.com/package/@ckeditor/ckeditor5-code-block): v38.0.0 => v38.0.1
* [@ckeditor/ckeditor5-collaboration-core](https://www.npmjs.com/package/@ckeditor/ckeditor5-collaboration-core): v38.0.0 => v38.0.1
* [@ckeditor/ckeditor5-comments](https://www.npmjs.com/package/@ckeditor/ckeditor5-comments): v38.0.0 => v38.0.1
* [@ckeditor/ckeditor5-core](https://www.npmjs.com/package/@ckeditor/ckeditor5-core): v38.0.0 => v38.0.1
* [@ckeditor/ckeditor5-document-outline](https://www.npmjs.com/package/@ckeditor/ckeditor5-document-outline): v38.0.0 => v38.0.1
* [@ckeditor/ckeditor5-easy-image](https://www.npmjs.com/package/@ckeditor/ckeditor5-easy-image): v38.0.0 => v38.0.1
* [@ckeditor/ckeditor5-editor-balloon](https://www.npmjs.com/package/@ckeditor/ckeditor5-editor-balloon): v38.0.0 => v38.0.1
* [@ckeditor/ckeditor5-editor-classic](https://www.npmjs.com/package/@ckeditor/ckeditor5-editor-classic): v38.0.0 => v38.0.1
* [@ckeditor/ckeditor5-editor-decoupled](https://www.npmjs.com/package/@ckeditor/ckeditor5-editor-decoupled): v38.0.0 => v38.0.1
* [@ckeditor/ckeditor5-editor-inline](https://www.npmjs.com/package/@ckeditor/ckeditor5-editor-inline): v38.0.0 => v38.0.1
* [@ckeditor/ckeditor5-editor-multi-root](https://www.npmjs.com/package/@ckeditor/ckeditor5-editor-multi-root): v38.0.0 => v38.0.1
* [@ckeditor/ckeditor5-engine](https://www.npmjs.com/package/@ckeditor/ckeditor5-engine): v38.0.0 => v38.0.1
* [@ckeditor/ckeditor5-enter](https://www.npmjs.com/package/@ckeditor/ckeditor5-enter): v38.0.0 => v38.0.1
* [@ckeditor/ckeditor5-essentials](https://www.npmjs.com/package/@ckeditor/ckeditor5-essentials): v38.0.0 => v38.0.1
* [@ckeditor/ckeditor5-export-pdf](https://www.npmjs.com/package/@ckeditor/ckeditor5-export-pdf): v38.0.0 => v38.0.1
* [@ckeditor/ckeditor5-export-word](https://www.npmjs.com/package/@ckeditor/ckeditor5-export-word): v38.0.0 => v38.0.1
* [@ckeditor/ckeditor5-find-and-replace](https://www.npmjs.com/package/@ckeditor/ckeditor5-find-and-replace): v38.0.0 => v38.0.1
* [@ckeditor/ckeditor5-font](https://www.npmjs.com/package/@ckeditor/ckeditor5-font): v38.0.0 => v38.0.1
* [@ckeditor/ckeditor5-format-painter](https://www.npmjs.com/package/@ckeditor/ckeditor5-format-painter): v38.0.0 => v38.0.1
* [@ckeditor/ckeditor5-heading](https://www.npmjs.com/package/@ckeditor/ckeditor5-heading): v38.0.0 => v38.0.1
* [@ckeditor/ckeditor5-highlight](https://www.npmjs.com/package/@ckeditor/ckeditor5-highlight): v38.0.0 => v38.0.1
* [@ckeditor/ckeditor5-horizontal-line](https://www.npmjs.com/package/@ckeditor/ckeditor5-horizontal-line): v38.0.0 => v38.0.1
* [@ckeditor/ckeditor5-html-embed](https://www.npmjs.com/package/@ckeditor/ckeditor5-html-embed): v38.0.0 => v38.0.1
* [@ckeditor/ckeditor5-html-support](https://www.npmjs.com/package/@ckeditor/ckeditor5-html-support): v38.0.0 => v38.0.1
* [@ckeditor/ckeditor5-image](https://www.npmjs.com/package/@ckeditor/ckeditor5-image): v38.0.0 => v38.0.1
* [@ckeditor/ckeditor5-import-word](https://www.npmjs.com/package/@ckeditor/ckeditor5-import-word): v38.0.0 => v38.0.1
* [@ckeditor/ckeditor5-indent](https://www.npmjs.com/package/@ckeditor/ckeditor5-indent): v38.0.0 => v38.0.1
* [@ckeditor/ckeditor5-language](https://www.npmjs.com/package/@ckeditor/ckeditor5-language): v38.0.0 => v38.0.1
* [@ckeditor/ckeditor5-link](https://www.npmjs.com/package/@ckeditor/ckeditor5-link): v38.0.0 => v38.0.1
* [@ckeditor/ckeditor5-list](https://www.npmjs.com/package/@ckeditor/ckeditor5-list): v38.0.0 => v38.0.1
* [@ckeditor/ckeditor5-markdown-gfm](https://www.npmjs.com/package/@ckeditor/ckeditor5-markdown-gfm): v38.0.0 => v38.0.1
* [@ckeditor/ckeditor5-media-embed](https://www.npmjs.com/package/@ckeditor/ckeditor5-media-embed): v38.0.0 => v38.0.1
* [@ckeditor/ckeditor5-mention](https://www.npmjs.com/package/@ckeditor/ckeditor5-mention): v38.0.0 => v38.0.1
* [@ckeditor/ckeditor5-minimap](https://www.npmjs.com/package/@ckeditor/ckeditor5-minimap): v38.0.0 => v38.0.1
* [@ckeditor/ckeditor5-operations-compressor](https://www.npmjs.com/package/@ckeditor/ckeditor5-operations-compressor): v38.0.0 => v38.0.1
* [@ckeditor/ckeditor5-page-break](https://www.npmjs.com/package/@ckeditor/ckeditor5-page-break): v38.0.0 => v38.0.1
* [@ckeditor/ckeditor5-pagination](https://www.npmjs.com/package/@ckeditor/ckeditor5-pagination): v38.0.0 => v38.0.1
* [@ckeditor/ckeditor5-paragraph](https://www.npmjs.com/package/@ckeditor/ckeditor5-paragraph): v38.0.0 => v38.0.1
* [@ckeditor/ckeditor5-paste-from-office](https://www.npmjs.com/package/@ckeditor/ckeditor5-paste-from-office): v38.0.0 => v38.0.1
* [@ckeditor/ckeditor5-real-time-collaboration](https://www.npmjs.com/package/@ckeditor/ckeditor5-real-time-collaboration): v38.0.0 => v38.0.1
* [@ckeditor/ckeditor5-remove-format](https://www.npmjs.com/package/@ckeditor/ckeditor5-remove-format): v38.0.0 => v38.0.1
* [@ckeditor/ckeditor5-restricted-editing](https://www.npmjs.com/package/@ckeditor/ckeditor5-restricted-editing): v38.0.0 => v38.0.1
* [@ckeditor/ckeditor5-revision-history](https://www.npmjs.com/package/@ckeditor/ckeditor5-revision-history): v38.0.0 => v38.0.1
* [@ckeditor/ckeditor5-select-all](https://www.npmjs.com/package/@ckeditor/ckeditor5-select-all): v38.0.0 => v38.0.1
* [@ckeditor/ckeditor5-slash-command](https://www.npmjs.com/package/@ckeditor/ckeditor5-slash-command): v38.0.0 => v38.0.1
* [@ckeditor/ckeditor5-source-editing](https://www.npmjs.com/package/@ckeditor/ckeditor5-source-editing): v38.0.0 => v38.0.1
* [@ckeditor/ckeditor5-special-characters](https://www.npmjs.com/package/@ckeditor/ckeditor5-special-characters): v38.0.0 => v38.0.1
* [@ckeditor/ckeditor5-style](https://www.npmjs.com/package/@ckeditor/ckeditor5-style): v38.0.0 => v38.0.1
* [@ckeditor/ckeditor5-table](https://www.npmjs.com/package/@ckeditor/ckeditor5-table): v38.0.0 => v38.0.1
* [@ckeditor/ckeditor5-template](https://www.npmjs.com/package/@ckeditor/ckeditor5-template): v38.0.0 => v38.0.1
* [@ckeditor/ckeditor5-theme-lark](https://www.npmjs.com/package/@ckeditor/ckeditor5-theme-lark): v38.0.0 => v38.0.1
* [@ckeditor/ckeditor5-track-changes](https://www.npmjs.com/package/@ckeditor/ckeditor5-track-changes): v38.0.0 => v38.0.1
* [@ckeditor/ckeditor5-typing](https://www.npmjs.com/package/@ckeditor/ckeditor5-typing): v38.0.0 => v38.0.1
* [@ckeditor/ckeditor5-ui](https://www.npmjs.com/package/@ckeditor/ckeditor5-ui): v38.0.0 => v38.0.1
* [@ckeditor/ckeditor5-undo](https://www.npmjs.com/package/@ckeditor/ckeditor5-undo): v38.0.0 => v38.0.1
* [@ckeditor/ckeditor5-upload](https://www.npmjs.com/package/@ckeditor/ckeditor5-upload): v38.0.0 => v38.0.1
* [@ckeditor/ckeditor5-utils](https://www.npmjs.com/package/@ckeditor/ckeditor5-utils): v38.0.0 => v38.0.1
* [@ckeditor/ckeditor5-watchdog](https://www.npmjs.com/package/@ckeditor/ckeditor5-watchdog): v38.0.0 => v38.0.1
* [@ckeditor/ckeditor5-widget](https://www.npmjs.com/package/@ckeditor/ckeditor5-widget): v38.0.0 => v38.0.1
* [@ckeditor/ckeditor5-word-count](https://www.npmjs.com/package/@ckeditor/ckeditor5-word-count): v38.0.0 => v38.0.1
* [@ckeditor/letters](https://www.npmjs.com/package/@ckeditor/letters): v38.0.0 => v38.0.1
* [ckeditor5-collaboration](https://www.npmjs.com/package/ckeditor5-collaboration): v38.0.0 => v38.0.1
</details>


## [38.0.0](https://github.com/ckeditor/ckeditor5/compare/v37.1.0...v38.0.0) (2023-05-22)

### Release highlights

#### "Powered by CKEditor" logo

From version v38.0.0 onwards, all open-source installations of CKEditor (using it under the GPL terms) will carry a small “Powered by CKEditor” logo in the bottom-right corner of the editing area. This new logo links directly to the [CKEditor website](https://ckeditor.com/) to strengthen the awareness of who’s powering and modernizing their rich text editor.

This change does not affect customers with commercial licenses. You can reach out to our Technical Support team using [this form](https://ckeditor.com/contact/), if you have any questions.

You can read more about this change in the [announcement on GitHub](https://github.com/ckeditor/ckeditor5/issues/14082), the [update guide](https://ckeditor.com/docs/ckeditor5/latest/updating/guides/update-to-38.html), and the [Managing the "Powered by CKEditor" logo guide](https://ckeditor.com/docs/ckeditor5/latest/support/licensing/managing-ckeditor-logo.html).

#### Color picker

Until v38.0.0, users were only able to choose from predefined colors in features like font color, font background color, table border color, etc. Starting from v38.0.0, they can also use a color picker to choose any possible color.

The color picker is now available in the font color and font background color features. In the upcoming versions (next month), it will be added to the table-related color features.

If you're interested in keeping the old behavior where the user can choose only from predefined colors, check out the [update guide](https://ckeditor.com/docs/ckeditor5/latest/updating/guides/update-to-38.html).

#### Styles

The latest update allows users to [apply styling](https://ckeditor.com/docs/ckeditor5/latest/features/style.html) to tables and their elements, as well as to lists and their items (`DocumentList` plugin). We've also fixed the behavior for links, so styles now only apply to the entire link. In addition, we've implemented a few bug fixes to address prior inconsistencies and issues.

### MAJOR BREAKING CHANGES [ℹ️](https://ckeditor.com/docs/ckeditor5/latest/framework/guides/support/versioning-policy.html#major-and-minor-breaking-changes)

* Introduced the "Powered by CKEditor" logo.

### MINOR BREAKING CHANGES [ℹ️](https://ckeditor.com/docs/ckeditor5/latest/framework/guides/support/versioning-policy.html#major-and-minor-breaking-changes)

* **[font](https://www.npmjs.com/package/@ckeditor/ckeditor5-font)**: Color picker is now added by default to the font color and font background color dropdowns. Thanks to it, users can apply any color through these features. In places where users should use a limited number of colors, it is possible to disable the color picker using a configuration option.
* **[track-changes](https://www.npmjs.com/package/@ckeditor/ckeditor5-track-changes)**: Introduced new values for the `trackFormatChanges` configuration parameter. Previously possible values were `true` or `false`. New possible values are: `'always'`, `'default'` (the old `true`), and `'never'` (the old `false`). Please update your configuration accordingly.
* Changed the look of the buttons in the comments and suggestions annotations. Previously, the buttons to add a comment, add a reply, or save the edited comment were represented by icons. Now they are proper buttons with text labels.

### Features

* **[clipboard](https://www.npmjs.com/package/@ckeditor/ckeditor5-clipboard)**: Introduced experimental support for block drag & drop. Closes [#14033](https://github.com/ckeditor/ckeditor5/issues/14033). ([commit](https://github.com/ckeditor/ckeditor5/commit/44cb8cb9b090feb4797a73a65cde1cfd97b48035))
* **[comments](https://www.npmjs.com/package/@ckeditor/ckeditor5-comments)**: Added support for resolved comment threads imported from Word.
* **[editor-multi-root](https://www.npmjs.com/package/@ckeditor/ckeditor5-editor-multi-root)**: Introduced the `MultiRootEditor#disableRoot()` and `MultiRootEditor#enableRoot()` methods that allow switching only a particular root to a read-only state. ([commit](https://github.com/ckeditor/ckeditor5/commit/4e28b171d5a517c2d91a3e38504c12d4c869ba69))
* **[engine](https://www.npmjs.com/package/@ckeditor/ckeditor5-engine)**: Introduced the `Model#canEditAt( selectable )` method that checks whether a given `selectable` is in an editable place in the model. It should be used instead of `Editor#isReadOnly` in multi-root integrations as it acknowledges the root's read-only state. ([commit](https://github.com/ckeditor/ckeditor5/commit/4e28b171d5a517c2d91a3e38504c12d4c869ba69))
* **[font](https://www.npmjs.com/package/@ckeditor/ckeditor5-font)**: Introduced the color picker feature for font and font background colors. Closes [#10988](https://github.com/ckeditor/ckeditor5/issues/10988). ([commit](https://github.com/ckeditor/ckeditor5/commit/23227a6725aacf8e37d4c5d64d724a30decaf354))
* **[style](https://www.npmjs.com/package/@ckeditor/ckeditor5-style)**: The styles dropdown now applies link styles only to the entire link. Closes [#11709](https://github.com/ckeditor/ckeditor5/issues/11709). ([commit](https://github.com/ckeditor/ckeditor5/commit/f23d002bcc3288e4c500353bec4d44f054f516ef))
* **[style](https://www.npmjs.com/package/@ckeditor/ckeditor5-style)**: Added custom styling support for the `<td>`, `<th>`, `<caption>`, and `<figcaption>` elements. Closes [#13777](https://github.com/ckeditor/ckeditor5/issues/13777). ([commit](https://github.com/ckeditor/ckeditor5/commit/92b418d05f9a1f5608b5356dbc6c1573be04f415))
* **[style](https://www.npmjs.com/package/@ckeditor/ckeditor5-style)**: Added support for the document lists feature. Closes [#11590](https://github.com/ckeditor/ckeditor5/issues/11590), [#12668](https://github.com/ckeditor/ckeditor5/issues/12668). ([commit](https://github.com/ckeditor/ckeditor5/commit/f4ddda86ecbb762565a90a7ba8a9fa5290796803))
* **[style](https://www.npmjs.com/package/@ckeditor/ckeditor5-style)**: The `<figure>` element can now be styled. See [#11590](https://github.com/ckeditor/ckeditor5/issues/11590). ([commit](https://github.com/ckeditor/ckeditor5/commit/f4ddda86ecbb762565a90a7ba8a9fa5290796803))
* **[track-changes](https://www.npmjs.com/package/@ckeditor/ckeditor5-track-changes)**: Added more granular changes tracking.
* **[track-changes](https://www.npmjs.com/package/@ckeditor/ckeditor5-track-changes)**: Introduced a new configuration parameter: `mergeNestedSuggestions: boolean` (default `true`). Introduced new values for the `trackFormatChanges` configuration parameter. See the API reference for more details.
* **[ui](https://www.npmjs.com/package/@ckeditor/ckeditor5-ui)**: Introduced the color picker view. See [#10988](https://github.com/ckeditor/ckeditor5/issues/10988). ([commit](https://github.com/ckeditor/ckeditor5/commit/23227a6725aacf8e37d4c5d64d724a30decaf354))

### Bug fixes

* **[comments](https://www.npmjs.com/package/@ckeditor/ckeditor5-comments)**: The mentions dropdown no longer appears behind the comments archive dropdown panel and is now accessible.
* **[comments](https://www.npmjs.com/package/@ckeditor/ckeditor5-comments)**: Fixed an error thrown when a resolved comment thread was received in a particular scenario.
* **[comments](https://www.npmjs.com/package/@ckeditor/ckeditor5-comments)**: The comments archive panel is now correctly visible when the comments archive is opened from various toolbars.
* **[comments](https://www.npmjs.com/package/@ckeditor/ckeditor5-comments)**: The comment thread `attributes` are now correctly returned in `CommentsRepository#getCommentThreads()`.
* **[comments](https://www.npmjs.com/package/@ckeditor/ckeditor5-comments)**: Fixed the comment thread input area which was incorrectly displayed or hidden in particular cases.
* **[comments](https://www.npmjs.com/package/@ckeditor/ckeditor5-comments)**: Fixed the editor crash when a comment was added to a comment thread imported from a Word file.
* **[core](https://www.npmjs.com/package/@ckeditor/ckeditor5-core)**: Added the `licenseKey` property to the `EditorConfig` interface. Closes [#13906](https://github.com/ckeditor/ckeditor5/issues/13906). ([commit](https://github.com/ckeditor/ckeditor5/commit/7e3e93c52fea343c3c850c4b9bcdcb97529f1bf6))
* **[document-outline](https://www.npmjs.com/package/@ckeditor/ckeditor5-document-outline)**: The document outline and table of contents features should now support the multi-root editor.
* **[document-outline](https://www.npmjs.com/package/@ckeditor/ckeditor5-document-outline)**: The document outline and table of contents features should not display placeholders for empty headings by default.
* **[engine](https://www.npmjs.com/package/@ckeditor/ckeditor5-engine)**: TypeScript should suggest `editingDowncast` and `dataDowncast` in `conversion.for`. Closes [#13750](https://github.com/ckeditor/ckeditor5/issues/13750). ([commit](https://github.com/ckeditor/ckeditor5/commit/51e1b17955538db3c64bc97ee071f8199e99bcd7))
* **[engine](https://www.npmjs.com/package/@ckeditor/ckeditor5-engine)**: The editor should not crash when a custom element with an invalid attribute name is pasted. Closes [#13841](https://github.com/ckeditor/ckeditor5/issues/13841). ([commit](https://github.com/ckeditor/ckeditor5/commit/2389d304c3a178a8ffcab26d86c97bbc98c44b0e))
* **[font](https://www.npmjs.com/package/@ckeditor/ckeditor5-font)**: Screen readers should now announce the selected option in dropdown lists for the font size, font family, and heading features. Closes [#13250](https://github.com/ckeditor/ckeditor5/issues/13250). ([commit](https://github.com/ckeditor/ckeditor5/commit/2fe4416c313d568fb41db1904fd80061b36bb957))
* **[heading](https://www.npmjs.com/package/@ckeditor/ckeditor5-heading)**: Screen readers should now announce the selected option in dropdown lists for the font size, font family, and heading features. Closes [#13250](https://github.com/ckeditor/ckeditor5/issues/13250). ([commit](https://github.com/ckeditor/ckeditor5/commit/2fe4416c313d568fb41db1904fd80061b36bb957))
* **[html-support](https://www.npmjs.com/package/@ckeditor/ckeditor5-html-support)**: Fixed the editor crash when pasting a table from Google Sheets. Closes [#13876](https://github.com/ckeditor/ckeditor5/issues/13876). ([commit](https://github.com/ckeditor/ckeditor5/commit/2abd9ff7c404f1f6c32e64c68dcde13d07177d8d))
* **[html-support](https://www.npmjs.com/package/@ckeditor/ckeditor5-html-support)**: HTML classes from a paragraph created after pressing the <kbd>Enter</kbd> key in a heading are now removed. Closes [#11578](https://github.com/ckeditor/ckeditor5/issues/11578). ([commit](https://github.com/ckeditor/ckeditor5/commit/77091ec981a98a0d02291f9da23ef3e5bcdf9d8b))
* **[paste-from-office](https://www.npmjs.com/package/@ckeditor/ckeditor5-paste-from-office)**: Fixed the width of tables pasted from Google Sheets. Closes [#13746](https://github.com/ckeditor/ckeditor5/issues/13746). ([commit](https://github.com/ckeditor/ckeditor5/commit/2abd9ff7c404f1f6c32e64c68dcde13d07177d8d))
* **[revision-history](https://www.npmjs.com/package/@ckeditor/ckeditor5-revision-history)**: Fixed the editor crash when a legacy revision (created using the editor in version 37.1.0 or older) was restored.
* **[style](https://www.npmjs.com/package/@ckeditor/ckeditor5-style)**: The remove format feature should also remove styles. Closes [#11580](https://github.com/ckeditor/ckeditor5/issues/11580). ([commit](https://github.com/ckeditor/ckeditor5/commit/ca522536ef0a1a3500af30e1736e2a8b91c1dd31))
* **[style](https://www.npmjs.com/package/@ckeditor/ckeditor5-style)**: The classes of the removed style are now preserved if other active styles also use them. Closes [#11748](https://github.com/ckeditor/ckeditor5/issues/11748). ([commit](https://github.com/ckeditor/ckeditor5/commit/823c7ffa934890b8116f29bab961e4b20306d217))
* **[table](https://www.npmjs.com/package/@ckeditor/ckeditor5-table)**: Removed comments with both `CK_DEBUG` and `istanbul` that break the Vite integration. See [#13922](https://github.com/ckeditor/ckeditor5/issues/13922). ([commit](https://github.com/ckeditor/ckeditor5/commit/ce9b09c631bbdd8afe304573f1e9ef5dd94fc1d4))
* **[track-changes](https://www.npmjs.com/package/@ckeditor/ckeditor5-track-changes)**: Fixed the integration of the remove format and format painter features.
* **[ui](https://www.npmjs.com/package/@ckeditor/ckeditor5-ui)**: The `mousedown` event should not be canceled on a UI button press so it can be dragged. See [#14033](https://github.com/ckeditor/ckeditor5/issues/14033). ([commit](https://github.com/ckeditor/ckeditor5/commit/44cb8cb9b090feb4797a73a65cde1cfd97b48035))
* **[ui](https://www.npmjs.com/package/@ckeditor/ckeditor5-ui)**: The toolbar should not disappear when the toolbar separator is clicked. The toolbar view should be focusable the same as the dropdown panel views. Closes [#12172](https://github.com/ckeditor/ckeditor5/issues/12172). ([commit](https://github.com/ckeditor/ckeditor5/commit/44cb8cb9b090feb4797a73a65cde1cfd97b48035))
* **[ui](https://www.npmjs.com/package/@ckeditor/ckeditor5-ui)**: Select all (<kbd>Ctrl</kbd>/<kbd>Cmd</kbd>+<kbd>A</kbd>) should now be enabled by default in an input field placed in a dropdown panel. Closes [#13982](https://github.com/ckeditor/ckeditor5/issues/13982). ([commit](https://github.com/ckeditor/ckeditor5/commit/78466837d66f43ae6609030af05f6a294aec19f8))
* Screen readers should announce the selected option in dropdown lists for the code block, language, image (resize options), special characters (categories), and table (border style) features. Closes [#13748](https://github.com/ckeditor/ckeditor5/issues/13748). ([commit](https://github.com/ckeditor/ckeditor5/commit/40533f7e672ce020e4d20db043bca07f91b586d3))

### Other changes

* **[comments](https://www.npmjs.com/package/@ckeditor/ckeditor5-comments)**: Changed the comments annotation button styles from icons to labeled buttons.
* **[comments](https://www.npmjs.com/package/@ckeditor/ckeditor5-comments)**: The comments archive header is now fixed at the top of the dropdown panel.
* **[image](https://www.npmjs.com/package/@ckeditor/ckeditor5-image)**: Changed the export type to export for plugins in the [@ckeditor/ckeditor5-image](https://www.npmjs.com/package/@ckeditor/ckeditor5-image) package. Closes [#13868](https://github.com/ckeditor/ckeditor5/issues/13868). ([commit](https://github.com/ckeditor/ckeditor5/commit/5b3f519043571335e6c1ec579c68a94d506e8d0e))
* **[track-changes](https://www.npmjs.com/package/@ckeditor/ckeditor5-track-changes)**: Changed the track changes annotation button styles from icons to labeled buttons.
* Optimized icons. ([commit](https://github.com/ckeditor/ckeditor5/commit/a7a99509c30183e4c1ed474d7da758551c575f99))
* Updated translations. ([commit](https://github.com/ckeditor/ckeditor5/commit/08682f5ac50097cf41a804e689c9355bb6dc16de), [commit](https://github.com/ckeditor/ckeditor5/commit/fdbbe4ef80917291c0d69ffe6831c976dd6da924))
* Introduced the "Powered by CKEditor" logo. ([commit](https://github.com/ckeditor/ckeditor5/commit/383ea8aefab9575edee969581527daa1561e7e07))

### Released packages

Check out the [Versioning policy](https://ckeditor.com/docs/ckeditor5/latest/framework/guides/support/versioning-policy.html) guide for more information.

<details>
<summary>Released packages (summary)</summary>

Minor releases (contain minor breaking changes):

* [@ckeditor/ckeditor5-font](https://www.npmjs.com/package/@ckeditor/ckeditor5-font): v37.1.0 => v38.0.0

Releases containing new features:

* [@ckeditor/ckeditor5-clipboard](https://www.npmjs.com/package/@ckeditor/ckeditor5-clipboard): v37.1.0 => v38.0.0
* [@ckeditor/ckeditor5-core](https://www.npmjs.com/package/@ckeditor/ckeditor5-core): v37.1.0 => v38.0.0
* [@ckeditor/ckeditor5-editor-multi-root](https://www.npmjs.com/package/@ckeditor/ckeditor5-editor-multi-root): v37.1.0 => v38.0.0
* [@ckeditor/ckeditor5-engine](https://www.npmjs.com/package/@ckeditor/ckeditor5-engine): v37.1.0 => v38.0.0
* [@ckeditor/ckeditor5-find-and-replace](https://www.npmjs.com/package/@ckeditor/ckeditor5-find-and-replace): v37.1.0 => v38.0.0
* [@ckeditor/ckeditor5-html-support](https://www.npmjs.com/package/@ckeditor/ckeditor5-html-support): v37.1.0 => v38.0.0
* [@ckeditor/ckeditor5-list](https://www.npmjs.com/package/@ckeditor/ckeditor5-list): v37.1.0 => v38.0.0
* [@ckeditor/ckeditor5-mention](https://www.npmjs.com/package/@ckeditor/ckeditor5-mention): v37.1.0 => v38.0.0
* [@ckeditor/ckeditor5-paragraph](https://www.npmjs.com/package/@ckeditor/ckeditor5-paragraph): v37.1.0 => v38.0.0
* [@ckeditor/ckeditor5-style](https://www.npmjs.com/package/@ckeditor/ckeditor5-style): v37.1.0 => v38.0.0
* [@ckeditor/ckeditor5-table](https://www.npmjs.com/package/@ckeditor/ckeditor5-table): v37.1.0 => v38.0.0
* [@ckeditor/ckeditor5-theme-lark](https://www.npmjs.com/package/@ckeditor/ckeditor5-theme-lark): v37.1.0 => v38.0.0
* [@ckeditor/ckeditor5-typing](https://www.npmjs.com/package/@ckeditor/ckeditor5-typing): v37.1.0 => v38.0.0
* [@ckeditor/ckeditor5-ui](https://www.npmjs.com/package/@ckeditor/ckeditor5-ui): v37.1.0 => v38.0.0
* [@ckeditor/ckeditor5-undo](https://www.npmjs.com/package/@ckeditor/ckeditor5-undo): v37.1.0 => v38.0.0
* [@ckeditor/ckeditor5-utils](https://www.npmjs.com/package/@ckeditor/ckeditor5-utils): v37.1.0 => v38.0.0
* [@ckeditor/ckeditor5-widget](https://www.npmjs.com/package/@ckeditor/ckeditor5-widget): v37.1.0 => v38.0.0

Other releases:

* [@ckeditor/ckeditor5-adapter-ckfinder](https://www.npmjs.com/package/@ckeditor/ckeditor5-adapter-ckfinder): v37.1.0 => v38.0.0
* [@ckeditor/ckeditor5-alignment](https://www.npmjs.com/package/@ckeditor/ckeditor5-alignment): v37.1.0 => v38.0.0
* [@ckeditor/ckeditor5-autoformat](https://www.npmjs.com/package/@ckeditor/ckeditor5-autoformat): v37.1.0 => v38.0.0
* [@ckeditor/ckeditor5-autosave](https://www.npmjs.com/package/@ckeditor/ckeditor5-autosave): v37.1.0 => v38.0.0
* [@ckeditor/ckeditor5-basic-styles](https://www.npmjs.com/package/@ckeditor/ckeditor5-basic-styles): v37.1.0 => v38.0.0
* [@ckeditor/ckeditor5-block-quote](https://www.npmjs.com/package/@ckeditor/ckeditor5-block-quote): v37.1.0 => v38.0.0
* [@ckeditor/ckeditor5-build-balloon](https://www.npmjs.com/package/@ckeditor/ckeditor5-build-balloon): v37.1.0 => v38.0.0
* [@ckeditor/ckeditor5-build-balloon-block](https://www.npmjs.com/package/@ckeditor/ckeditor5-build-balloon-block): v37.1.0 => v38.0.0
* [@ckeditor/ckeditor5-build-classic](https://www.npmjs.com/package/@ckeditor/ckeditor5-build-classic): v37.1.0 => v38.0.0
* [@ckeditor/ckeditor5-build-decoupled-document](https://www.npmjs.com/package/@ckeditor/ckeditor5-build-decoupled-document): v37.1.0 => v38.0.0
* [@ckeditor/ckeditor5-build-inline](https://www.npmjs.com/package/@ckeditor/ckeditor5-build-inline): v37.1.0 => v38.0.0
* [@ckeditor/ckeditor5-build-multi-root](https://www.npmjs.com/package/@ckeditor/ckeditor5-build-multi-root): v37.1.0 => v38.0.0
* [@ckeditor/ckeditor5-ckbox](https://www.npmjs.com/package/@ckeditor/ckeditor5-ckbox): v37.1.0 => v38.0.0
* [@ckeditor/ckeditor5-ckfinder](https://www.npmjs.com/package/@ckeditor/ckeditor5-ckfinder): v37.1.0 => v38.0.0
* [@ckeditor/ckeditor5-cloud-services](https://www.npmjs.com/package/@ckeditor/ckeditor5-cloud-services): v37.1.0 => v38.0.0
* [@ckeditor/ckeditor5-code-block](https://www.npmjs.com/package/@ckeditor/ckeditor5-code-block): v37.1.0 => v38.0.0
* [@ckeditor/ckeditor5-collaboration-core](https://www.npmjs.com/package/@ckeditor/ckeditor5-collaboration-core): v37.1.0 => v38.0.0
* [@ckeditor/ckeditor5-comments](https://www.npmjs.com/package/@ckeditor/ckeditor5-comments): v37.1.0 => v38.0.0
* [@ckeditor/ckeditor5-document-outline](https://www.npmjs.com/package/@ckeditor/ckeditor5-document-outline): v37.1.0 => v38.0.0
* [@ckeditor/ckeditor5-easy-image](https://www.npmjs.com/package/@ckeditor/ckeditor5-easy-image): v37.1.0 => v38.0.0
* [@ckeditor/ckeditor5-editor-balloon](https://www.npmjs.com/package/@ckeditor/ckeditor5-editor-balloon): v37.1.0 => v38.0.0
* [@ckeditor/ckeditor5-editor-classic](https://www.npmjs.com/package/@ckeditor/ckeditor5-editor-classic): v37.1.0 => v38.0.0
* [@ckeditor/ckeditor5-editor-decoupled](https://www.npmjs.com/package/@ckeditor/ckeditor5-editor-decoupled): v37.1.0 => v38.0.0
* [@ckeditor/ckeditor5-editor-inline](https://www.npmjs.com/package/@ckeditor/ckeditor5-editor-inline): v37.1.0 => v38.0.0
* [@ckeditor/ckeditor5-enter](https://www.npmjs.com/package/@ckeditor/ckeditor5-enter): v37.1.0 => v38.0.0
* [@ckeditor/ckeditor5-essentials](https://www.npmjs.com/package/@ckeditor/ckeditor5-essentials): v37.1.0 => v38.0.0
* [@ckeditor/ckeditor5-export-pdf](https://www.npmjs.com/package/@ckeditor/ckeditor5-export-pdf): v37.1.0 => v38.0.0
* [@ckeditor/ckeditor5-export-word](https://www.npmjs.com/package/@ckeditor/ckeditor5-export-word): v37.1.0 => v38.0.0
* [@ckeditor/ckeditor5-format-painter](https://www.npmjs.com/package/@ckeditor/ckeditor5-format-painter): v37.1.0 => v38.0.0
* [@ckeditor/ckeditor5-heading](https://www.npmjs.com/package/@ckeditor/ckeditor5-heading): v37.1.0 => v38.0.0
* [@ckeditor/ckeditor5-highlight](https://www.npmjs.com/package/@ckeditor/ckeditor5-highlight): v37.1.0 => v38.0.0
* [@ckeditor/ckeditor5-horizontal-line](https://www.npmjs.com/package/@ckeditor/ckeditor5-horizontal-line): v37.1.0 => v38.0.0
* [@ckeditor/ckeditor5-html-embed](https://www.npmjs.com/package/@ckeditor/ckeditor5-html-embed): v37.1.0 => v38.0.0
* [@ckeditor/ckeditor5-image](https://www.npmjs.com/package/@ckeditor/ckeditor5-image): v37.1.0 => v38.0.0
* [@ckeditor/ckeditor5-import-word](https://www.npmjs.com/package/@ckeditor/ckeditor5-import-word): v37.1.0 => v38.0.0
* [@ckeditor/ckeditor5-indent](https://www.npmjs.com/package/@ckeditor/ckeditor5-indent): v37.1.0 => v38.0.0
* [@ckeditor/ckeditor5-language](https://www.npmjs.com/package/@ckeditor/ckeditor5-language): v37.1.0 => v38.0.0
* [@ckeditor/ckeditor5-link](https://www.npmjs.com/package/@ckeditor/ckeditor5-link): v37.1.0 => v38.0.0
* [@ckeditor/ckeditor5-markdown-gfm](https://www.npmjs.com/package/@ckeditor/ckeditor5-markdown-gfm): v37.1.0 => v38.0.0
* [@ckeditor/ckeditor5-media-embed](https://www.npmjs.com/package/@ckeditor/ckeditor5-media-embed): v37.1.0 => v38.0.0
* [@ckeditor/ckeditor5-minimap](https://www.npmjs.com/package/@ckeditor/ckeditor5-minimap): v37.1.0 => v38.0.0
* [@ckeditor/ckeditor5-operations-compressor](https://www.npmjs.com/package/@ckeditor/ckeditor5-operations-compressor): v37.1.0 => v38.0.0
* [@ckeditor/ckeditor5-page-break](https://www.npmjs.com/package/@ckeditor/ckeditor5-page-break): v37.1.0 => v38.0.0
* [@ckeditor/ckeditor5-pagination](https://www.npmjs.com/package/@ckeditor/ckeditor5-pagination): v37.1.0 => v38.0.0
* [@ckeditor/ckeditor5-paste-from-office](https://www.npmjs.com/package/@ckeditor/ckeditor5-paste-from-office): v37.1.0 => v38.0.0
* [@ckeditor/ckeditor5-real-time-collaboration](https://www.npmjs.com/package/@ckeditor/ckeditor5-real-time-collaboration): v37.1.0 => v38.0.0
* [@ckeditor/ckeditor5-remove-format](https://www.npmjs.com/package/@ckeditor/ckeditor5-remove-format): v37.1.0 => v38.0.0
* [@ckeditor/ckeditor5-restricted-editing](https://www.npmjs.com/package/@ckeditor/ckeditor5-restricted-editing): v37.1.0 => v38.0.0
* [@ckeditor/ckeditor5-revision-history](https://www.npmjs.com/package/@ckeditor/ckeditor5-revision-history): v37.1.0 => v38.0.0
* [@ckeditor/ckeditor5-select-all](https://www.npmjs.com/package/@ckeditor/ckeditor5-select-all): v37.1.0 => v38.0.0
* [@ckeditor/ckeditor5-slash-command](https://www.npmjs.com/package/@ckeditor/ckeditor5-slash-command): v37.1.0 => v38.0.0
* [@ckeditor/ckeditor5-source-editing](https://www.npmjs.com/package/@ckeditor/ckeditor5-source-editing): v37.1.0 => v38.0.0
* [@ckeditor/ckeditor5-special-characters](https://www.npmjs.com/package/@ckeditor/ckeditor5-special-characters): v37.1.0 => v38.0.0
* [@ckeditor/ckeditor5-template](https://www.npmjs.com/package/@ckeditor/ckeditor5-template): v37.1.0 => v38.0.0
* [@ckeditor/ckeditor5-track-changes](https://www.npmjs.com/package/@ckeditor/ckeditor5-track-changes): v37.1.0 => v38.0.0
* [@ckeditor/ckeditor5-upload](https://www.npmjs.com/package/@ckeditor/ckeditor5-upload): v37.1.0 => v38.0.0
* [@ckeditor/ckeditor5-watchdog](https://www.npmjs.com/package/@ckeditor/ckeditor5-watchdog): v37.1.0 => v38.0.0
* [@ckeditor/ckeditor5-word-count](https://www.npmjs.com/package/@ckeditor/ckeditor5-word-count): v37.1.0 => v38.0.0
* [@ckeditor/letters](https://www.npmjs.com/package/@ckeditor/letters): v37.1.0 => v38.0.0
* [ckeditor5-collaboration](https://www.npmjs.com/package/ckeditor5-collaboration): v37.1.0 => v38.0.0
</details>


## [38.0.0-rc.1](https://github.com/ckeditor/ckeditor5/compare/v37.1.0...v38.0.0-rc.1) (2023-05-16)

This is a hotfix release that addresses problems discovered after publishing code for our previous RC release. Please check the changelog for version `38.0.0-rc.0` below as well.

### Released packages

Check out the [Versioning policy](https://ckeditor.com/docs/ckeditor5/latest/framework/guides/support/versioning-policy.html) guide for more information.

<details>
<summary>Released packages (summary)</summary>

Minor releases (contain minor breaking changes):

* [@ckeditor/ckeditor5-font](https://www.npmjs.com/package/@ckeditor/ckeditor5-font): v38.0.0-rc.0 => v38.0.0-rc.1

Releases containing new features:

* [@ckeditor/ckeditor5-clipboard](https://www.npmjs.com/package/@ckeditor/ckeditor5-clipboard): v38.0.0-rc.0 => v38.0.0-rc.1
* [@ckeditor/ckeditor5-core](https://www.npmjs.com/package/@ckeditor/ckeditor5-core): v38.0.0-rc.0 => v38.0.0-rc.1
* [@ckeditor/ckeditor5-editor-multi-root](https://www.npmjs.com/package/@ckeditor/ckeditor5-editor-multi-root): v38.0.0-rc.0 => v38.0.0-rc.1
* [@ckeditor/ckeditor5-engine](https://www.npmjs.com/package/@ckeditor/ckeditor5-engine): v38.0.0-rc.0 => v38.0.0-rc.1
* [@ckeditor/ckeditor5-find-and-replace](https://www.npmjs.com/package/@ckeditor/ckeditor5-find-and-replace): v38.0.0-rc.0 => v38.0.0-rc.1
* [@ckeditor/ckeditor5-html-support](https://www.npmjs.com/package/@ckeditor/ckeditor5-html-support): v38.0.0-rc.0 => v38.0.0-rc.1
* [@ckeditor/ckeditor5-list](https://www.npmjs.com/package/@ckeditor/ckeditor5-list): v38.0.0-rc.0 => v38.0.0-rc.1
* [@ckeditor/ckeditor5-mention](https://www.npmjs.com/package/@ckeditor/ckeditor5-mention): v38.0.0-rc.0 => v38.0.0-rc.1
* [@ckeditor/ckeditor5-paragraph](https://www.npmjs.com/package/@ckeditor/ckeditor5-paragraph): v38.0.0-rc.0 => v38.0.0-rc.1
* [@ckeditor/ckeditor5-style](https://www.npmjs.com/package/@ckeditor/ckeditor5-style): v38.0.0-rc.0 => v38.0.0-rc.1
* [@ckeditor/ckeditor5-table](https://www.npmjs.com/package/@ckeditor/ckeditor5-table): v38.0.0-rc.0 => v38.0.0-rc.1
* [@ckeditor/ckeditor5-theme-lark](https://www.npmjs.com/package/@ckeditor/ckeditor5-theme-lark): v38.0.0-rc.0 => v38.0.0-rc.1
* [@ckeditor/ckeditor5-typing](https://www.npmjs.com/package/@ckeditor/ckeditor5-typing): v38.0.0-rc.0 => v38.0.0-rc.1
* [@ckeditor/ckeditor5-ui](https://www.npmjs.com/package/@ckeditor/ckeditor5-ui): v38.0.0-rc.0 => v38.0.0-rc.1
* [@ckeditor/ckeditor5-undo](https://www.npmjs.com/package/@ckeditor/ckeditor5-undo): v38.0.0-rc.0 => v38.0.0-rc.1
* [@ckeditor/ckeditor5-utils](https://www.npmjs.com/package/@ckeditor/ckeditor5-utils): v38.0.0-rc.0 => v38.0.0-rc.1
* [@ckeditor/ckeditor5-widget](https://www.npmjs.com/package/@ckeditor/ckeditor5-widget): v38.0.0-rc.0 => v38.0.0-rc.1

Other releases:

* [@ckeditor/ckeditor5-adapter-ckfinder](https://www.npmjs.com/package/@ckeditor/ckeditor5-adapter-ckfinder): v38.0.0-rc.0 => v38.0.0-rc.1
* [@ckeditor/ckeditor5-alignment](https://www.npmjs.com/package/@ckeditor/ckeditor5-alignment): v38.0.0-rc.0 => v38.0.0-rc.1
* [@ckeditor/ckeditor5-autoformat](https://www.npmjs.com/package/@ckeditor/ckeditor5-autoformat): v38.0.0-rc.0 => v38.0.0-rc.1
* [@ckeditor/ckeditor5-autosave](https://www.npmjs.com/package/@ckeditor/ckeditor5-autosave): v38.0.0-rc.0 => v38.0.0-rc.1
* [@ckeditor/ckeditor5-basic-styles](https://www.npmjs.com/package/@ckeditor/ckeditor5-basic-styles): v38.0.0-rc.0 => v38.0.0-rc.1
* [@ckeditor/ckeditor5-block-quote](https://www.npmjs.com/package/@ckeditor/ckeditor5-block-quote): v38.0.0-rc.0 => v38.0.0-rc.1
* [@ckeditor/ckeditor5-build-balloon](https://www.npmjs.com/package/@ckeditor/ckeditor5-build-balloon): v38.0.0-rc.0 => v38.0.0-rc.1
* [@ckeditor/ckeditor5-build-balloon-block](https://www.npmjs.com/package/@ckeditor/ckeditor5-build-balloon-block): v38.0.0-rc.0 => v38.0.0-rc.1
* [@ckeditor/ckeditor5-build-classic](https://www.npmjs.com/package/@ckeditor/ckeditor5-build-classic): v38.0.0-rc.0 => v38.0.0-rc.1
* [@ckeditor/ckeditor5-build-decoupled-document](https://www.npmjs.com/package/@ckeditor/ckeditor5-build-decoupled-document): v38.0.0-rc.0 => v38.0.0-rc.1
* [@ckeditor/ckeditor5-build-inline](https://www.npmjs.com/package/@ckeditor/ckeditor5-build-inline): v38.0.0-rc.0 => v38.0.0-rc.1
* [@ckeditor/ckeditor5-build-multi-root](https://www.npmjs.com/package/@ckeditor/ckeditor5-build-multi-root): v38.0.0-rc.0 => v38.0.0-rc.1
* [@ckeditor/ckeditor5-ckbox](https://www.npmjs.com/package/@ckeditor/ckeditor5-ckbox): v38.0.0-rc.0 => v38.0.0-rc.1
* [@ckeditor/ckeditor5-ckfinder](https://www.npmjs.com/package/@ckeditor/ckeditor5-ckfinder): v38.0.0-rc.0 => v38.0.0-rc.1
* [@ckeditor/ckeditor5-cloud-services](https://www.npmjs.com/package/@ckeditor/ckeditor5-cloud-services): v38.0.0-rc.0 => v38.0.0-rc.1
* [@ckeditor/ckeditor5-code-block](https://www.npmjs.com/package/@ckeditor/ckeditor5-code-block): v38.0.0-rc.0 => v38.0.0-rc.1
* [@ckeditor/ckeditor5-collaboration-core](https://www.npmjs.com/package/@ckeditor/ckeditor5-collaboration-core): v38.0.0-rc.0 => v38.0.0-rc.1
* [@ckeditor/ckeditor5-comments](https://www.npmjs.com/package/@ckeditor/ckeditor5-comments): v38.0.0-rc.0 => v38.0.0-rc.1
* [@ckeditor/ckeditor5-document-outline](https://www.npmjs.com/package/@ckeditor/ckeditor5-document-outline): v38.0.0-rc.0 => v38.0.0-rc.1
* [@ckeditor/ckeditor5-easy-image](https://www.npmjs.com/package/@ckeditor/ckeditor5-easy-image): v38.0.0-rc.0 => v38.0.0-rc.1
* [@ckeditor/ckeditor5-editor-balloon](https://www.npmjs.com/package/@ckeditor/ckeditor5-editor-balloon): v38.0.0-rc.0 => v38.0.0-rc.1
* [@ckeditor/ckeditor5-editor-classic](https://www.npmjs.com/package/@ckeditor/ckeditor5-editor-classic): v38.0.0-rc.0 => v38.0.0-rc.1
* [@ckeditor/ckeditor5-editor-decoupled](https://www.npmjs.com/package/@ckeditor/ckeditor5-editor-decoupled): v38.0.0-rc.0 => v38.0.0-rc.1
* [@ckeditor/ckeditor5-editor-inline](https://www.npmjs.com/package/@ckeditor/ckeditor5-editor-inline): v38.0.0-rc.0 => v38.0.0-rc.1
* [@ckeditor/ckeditor5-enter](https://www.npmjs.com/package/@ckeditor/ckeditor5-enter): v38.0.0-rc.0 => v38.0.0-rc.1
* [@ckeditor/ckeditor5-essentials](https://www.npmjs.com/package/@ckeditor/ckeditor5-essentials): v38.0.0-rc.0 => v38.0.0-rc.1
* [@ckeditor/ckeditor5-export-pdf](https://www.npmjs.com/package/@ckeditor/ckeditor5-export-pdf): v38.0.0-rc.0 => v38.0.0-rc.1
* [@ckeditor/ckeditor5-export-word](https://www.npmjs.com/package/@ckeditor/ckeditor5-export-word): v38.0.0-rc.0 => v38.0.0-rc.1
* [@ckeditor/ckeditor5-format-painter](https://www.npmjs.com/package/@ckeditor/ckeditor5-format-painter): v38.0.0-rc.0 => v38.0.0-rc.1
* [@ckeditor/ckeditor5-heading](https://www.npmjs.com/package/@ckeditor/ckeditor5-heading): v38.0.0-rc.0 => v38.0.0-rc.1
* [@ckeditor/ckeditor5-highlight](https://www.npmjs.com/package/@ckeditor/ckeditor5-highlight): v38.0.0-rc.0 => v38.0.0-rc.1
* [@ckeditor/ckeditor5-horizontal-line](https://www.npmjs.com/package/@ckeditor/ckeditor5-horizontal-line): v38.0.0-rc.0 => v38.0.0-rc.1
* [@ckeditor/ckeditor5-html-embed](https://www.npmjs.com/package/@ckeditor/ckeditor5-html-embed): v38.0.0-rc.0 => v38.0.0-rc.1
* [@ckeditor/ckeditor5-image](https://www.npmjs.com/package/@ckeditor/ckeditor5-image): v38.0.0-rc.0 => v38.0.0-rc.1
* [@ckeditor/ckeditor5-import-word](https://www.npmjs.com/package/@ckeditor/ckeditor5-import-word): v38.0.0-rc.0 => v38.0.0-rc.1
* [@ckeditor/ckeditor5-indent](https://www.npmjs.com/package/@ckeditor/ckeditor5-indent): v38.0.0-rc.0 => v38.0.0-rc.1
* [@ckeditor/ckeditor5-language](https://www.npmjs.com/package/@ckeditor/ckeditor5-language): v38.0.0-rc.0 => v38.0.0-rc.1
* [@ckeditor/ckeditor5-link](https://www.npmjs.com/package/@ckeditor/ckeditor5-link): v38.0.0-rc.0 => v38.0.0-rc.1
* [@ckeditor/ckeditor5-markdown-gfm](https://www.npmjs.com/package/@ckeditor/ckeditor5-markdown-gfm): v38.0.0-rc.0 => v38.0.0-rc.1
* [@ckeditor/ckeditor5-media-embed](https://www.npmjs.com/package/@ckeditor/ckeditor5-media-embed): v38.0.0-rc.0 => v38.0.0-rc.1
* [@ckeditor/ckeditor5-minimap](https://www.npmjs.com/package/@ckeditor/ckeditor5-minimap): v38.0.0-rc.0 => v38.0.0-rc.1
* [@ckeditor/ckeditor5-operations-compressor](https://www.npmjs.com/package/@ckeditor/ckeditor5-operations-compressor): v38.0.0-rc.0 => v38.0.0-rc.1
* [@ckeditor/ckeditor5-page-break](https://www.npmjs.com/package/@ckeditor/ckeditor5-page-break): v38.0.0-rc.0 => v38.0.0-rc.1
* [@ckeditor/ckeditor5-pagination](https://www.npmjs.com/package/@ckeditor/ckeditor5-pagination): v38.0.0-rc.0 => v38.0.0-rc.1
* [@ckeditor/ckeditor5-paste-from-office](https://www.npmjs.com/package/@ckeditor/ckeditor5-paste-from-office): v38.0.0-rc.0 => v38.0.0-rc.1
* [@ckeditor/ckeditor5-real-time-collaboration](https://www.npmjs.com/package/@ckeditor/ckeditor5-real-time-collaboration): v38.0.0-rc.0 => v38.0.0-rc.1
* [@ckeditor/ckeditor5-remove-format](https://www.npmjs.com/package/@ckeditor/ckeditor5-remove-format): v38.0.0-rc.0 => v38.0.0-rc.1
* [@ckeditor/ckeditor5-restricted-editing](https://www.npmjs.com/package/@ckeditor/ckeditor5-restricted-editing): v38.0.0-rc.0 => v38.0.0-rc.1
* [@ckeditor/ckeditor5-revision-history](https://www.npmjs.com/package/@ckeditor/ckeditor5-revision-history): v38.0.0-rc.0 => v38.0.0-rc.1
* [@ckeditor/ckeditor5-select-all](https://www.npmjs.com/package/@ckeditor/ckeditor5-select-all): v38.0.0-rc.0 => v38.0.0-rc.1
* [@ckeditor/ckeditor5-slash-command](https://www.npmjs.com/package/@ckeditor/ckeditor5-slash-command): v38.0.0-rc.0 => v38.0.0-rc.1
* [@ckeditor/ckeditor5-source-editing](https://www.npmjs.com/package/@ckeditor/ckeditor5-source-editing): v38.0.0-rc.0 => v38.0.0-rc.1
* [@ckeditor/ckeditor5-special-characters](https://www.npmjs.com/package/@ckeditor/ckeditor5-special-characters): v38.0.0-rc.0 => v38.0.0-rc.1
* [@ckeditor/ckeditor5-template](https://www.npmjs.com/package/@ckeditor/ckeditor5-template): v38.0.0-rc.0 => v38.0.0-rc.1
* [@ckeditor/ckeditor5-track-changes](https://www.npmjs.com/package/@ckeditor/ckeditor5-track-changes): v38.0.0-rc.0 => v38.0.0-rc.1
* [@ckeditor/ckeditor5-upload](https://www.npmjs.com/package/@ckeditor/ckeditor5-upload): v38.0.0-rc.0 => v38.0.0-rc.1
* [@ckeditor/ckeditor5-watchdog](https://www.npmjs.com/package/@ckeditor/ckeditor5-watchdog): v38.0.0-rc.0 => v38.0.0-rc.1
* [@ckeditor/ckeditor5-word-count](https://www.npmjs.com/package/@ckeditor/ckeditor5-word-count): v38.0.0-rc.0 => v38.0.0-rc.1
* [@ckeditor/letters](https://www.npmjs.com/package/@ckeditor/letters): v38.0.0-rc.0 => v38.0.0-rc.1
* [ckeditor5-collaboration](https://www.npmjs.com/package/ckeditor5-collaboration): v38.0.0-rc.0 => v38.0.0-rc.1
</details>

---

To see all releases, visit the [release page](https://github.com/ckeditor/ckeditor5/releases).
