'use strict';

const path = require('path');
const params = require('./params.cjs');
const option = require('./option.cjs');
const command$1 = require('./command.cjs');
const parseArgvError = require('./parse-argv-error.cjs');
const help = require('./help.cjs');

function nameFromProcessArgv() {
    return path.basename(process.argv[1], path.extname(process.argv[1]));
}

function command(usageOrCommand, ...rest) {
    return new command$1(
        usageOrCommand || nameFromProcessArgv() || 'command',
        ...rest
    );
}

exports.Params = params;
exports.Option = option;
exports.Command = command$1;
exports.Error = parseArgvError;
exports.getCommandHelp = help;
exports.command = command;
