/**
 * SPDX-FileCopyrightText: © 2019 Liferay, Inc. <https://liferay.com>
 * SPDX-License-Identifier: BSD-3-Clause
 */
import React from 'react';
import Group from './Group';
declare type DisplayType = null | 'primary' | 'secondary' | 'link' | 'success' | 'warning' | 'danger' | 'info' | 'beta' | 'beta-dark' | 'unstyled';
export interface IProps extends React.ButtonHTMLAttributes<HTMLButtonElement> {
    /**
     * Flag to indicate if button is used within an alert component.
     */
    alert?: boolean;
    /**
     * Flag to indicate if the button should be borderless.
     */
    borderless?: boolean;
    /**
     * Renders the button as a block element.
     */
    block?: boolean;
    /**
     * Flag to indicate if the button should use the clay-dark variant.
     */
    dark?: boolean;
    /**
     * Determines the button variant to use.
     * The values `beta` and `beta-dark` are deprecated since v3.100.0 - use
     * `translucent` and `dark` instead.
     * The values `null` and `unstyled` are for internal use only.
     */
    displayType?: DisplayType;
    /**
     * Flag to display a loading indicator.
     */
    loading?: boolean;
    /**
     * Flag to indicate if button should be monospaced.
     */
    monospaced?: boolean;
    /**
     * Flag to indicate if the button should use the outline variant.
     */
    outline?: boolean;
    /**
     * Flag to indicate if the button should be shaped like a pill.
     */
    rounded?: boolean;
    /**
     * Determines the size of a button.
     */
    size?: 'xs' | 'regular' | 'sm';
    /**
     * Indicates button should be a small variant.
     * @deprecated since v3.72.0 - use `size` instead.
     */
    small?: boolean;
    /**
     * Flag to indicate if the button should use the translucent variant.
     */
    translucent?: boolean;
}
export interface IForwardRef<T, P = {}> extends React.ForwardRefExoticComponent<P & React.RefAttributes<T>> {
    Group: typeof Group;
}
declare const Button: IForwardRef<HTMLButtonElement, IProps>;
export default Button;
