function _extends() { return _extends = Object.assign ? Object.assign.bind() : function (n) { for (var e = 1; e < arguments.length; e++) { var t = arguments[e]; for (var r in t) ({}).hasOwnProperty.call(t, r) && (n[r] = t[r]); } return n; }, _extends.apply(null, arguments); }
/**
 * SPDX-FileCopyrightText: © 2019 Liferay, Inc. <https://liferay.com>
 * SPDX-License-Identifier: BSD-3-Clause
 */

import LoadingIndicator from '@clayui/loading-indicator';
import classNames from 'classnames';
import React from 'react';
import warning from 'warning';
import Group from "./Group.js";
function forwardRef(component) {
  return /*#__PURE__*/React.forwardRef(component);
}
const Button = forwardRef((_ref, ref) => {
  let {
    alert,
    block,
    borderless,
    children,
    className,
    dark,
    displayType = 'primary',
    loading,
    monospaced,
    outline,
    rounded,
    size = 'regular',
    small,
    translucent,
    type = 'button',
    ...otherProps
  } = _ref;
  const childArray = React.Children.toArray(children);
  undefined !== "production" ? warning(!(childArray.length === 1 &&
  // @ts-ignore
  childArray[0].type?.displayName === 'ClayIcon' && typeof otherProps['aria-label'] !== 'string' && typeof otherProps['aria-labelledby'] !== 'string'), 'Button Accessibility: Component has only the Icon declared. Define an `aria-label` or `aria-labelledby` attribute that labels the interactive button that screen readers can read. The `title` attribute is optional but consult your design team.') : void 0;
  if (displayType === 'beta') {
    displayType = 'info';
    translucent = true;
  } else if (displayType === 'beta-dark') {
    dark = true;
    displayType = 'info';
    translucent = true;
  }
  return /*#__PURE__*/React.createElement("button", _extends({
    className: classNames(className, 'btn', {
      'alert-btn': alert,
      'btn-block': block,
      'btn-monospaced': monospaced,
      'btn-outline-borderless': borderless,
      'btn-sm': small && (!size || size === 'regular'),
      'btn-translucent': translucent,
      'clay-dark': dark,
      [`btn-${displayType}`]: displayType && !outline && !borderless,
      [`btn-outline-${displayType}`]: displayType && (outline || borderless),
      'rounded-pill': rounded,
      [`btn-${size}`]: size && size !== 'regular'
    }),
    ref: ref,
    type: type
  }, otherProps), loading && /*#__PURE__*/React.createElement("span", {
    className: "inline-item inline-item-before"
  }, /*#__PURE__*/React.createElement(LoadingIndicator, null)), children);
});
Button.Group = Group;
Button.displayName = 'ClayButton';
export default Button;