"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.default = exports.ItemExpand = exports.ItemBefore = exports.ItemAfter = void 0;
var _icon = _interopRequireDefault(require("@clayui/icon"));
var _link = _interopRequireDefault(require("@clayui/link"));
var _classnames = _interopRequireDefault(require("classnames"));
var _react = _interopRequireDefault(require("react"));
function _interopRequireDefault(e) { return e && e.__esModule ? e : { default: e }; }
function _extends() { return _extends = Object.assign ? Object.assign.bind() : function (n) { for (var e = 1; e < arguments.length; e++) { var t = arguments[e]; for (var r in t) ({}).hasOwnProperty.call(t, r) && (n[r] = t[r]); } return n; }, _extends.apply(null, arguments); } /**
 * SPDX-FileCopyrightText: © 2019 Liferay, Inc. <https://liferay.com>
 * SPDX-License-Identifier: BSD-3-Clause
 */
const ItemAfter = exports.ItemAfter = /*#__PURE__*/_react.default.forwardRef((_ref, ref) => {
  let {
    children,
    className,
    ...otherProps
  } = _ref;
  return /*#__PURE__*/_react.default.createElement("span", _extends({}, otherProps, {
    className: (0, _classnames.default)(className, 'label-item label-item-after'),
    ref: ref
  }), children);
});
ItemAfter.displayName = 'ClayLabelItemAfter';
const ItemBefore = exports.ItemBefore = /*#__PURE__*/_react.default.forwardRef((_ref2, ref) => {
  let {
    children,
    className,
    ...otherProps
  } = _ref2;
  return /*#__PURE__*/_react.default.createElement("span", _extends({}, otherProps, {
    className: (0, _classnames.default)(className, 'label-item label-item-before'),
    ref: ref
  }), children);
});
ItemBefore.displayName = 'ClayLabelItemBefore';
const ItemExpand = exports.ItemExpand = /*#__PURE__*/_react.default.forwardRef((_ref3, ref) => {
  let {
    children,
    className,
    href,
    ...otherProps
  } = _ref3;
  const TagName = href ? _link.default : 'span';
  return /*#__PURE__*/_react.default.createElement(TagName, _extends({}, otherProps, {
    className: (0, _classnames.default)(className, 'label-item label-item-expand'),
    href: href,
    ref: ref
  }), children);
});
ItemExpand.displayName = 'ClayLabelItemExpand';
const OldLabel = /*#__PURE__*/_react.default.forwardRef((_ref4, ref) => {
  let {
    children,
    className,
    dismissible,
    displayType = 'secondary',
    large = false,
    ...otherProps
  } = _ref4;
  return /*#__PURE__*/_react.default.createElement("span", _extends({}, otherProps, {
    className: (0, _classnames.default)('label', className, {
      'label-dismissible': dismissible,
      'label-lg': large,
      [`label-${displayType}`]: displayType
    }),
    ref: ref
  }), children);
});
OldLabel.displayName = 'ClayLabel';
function forwardRef(component) {
  return /*#__PURE__*/_react.default.forwardRef(component);
}
const Label = forwardRef((_ref5, ref) => {
  let {
    children,
    closeButtonProps,
    href,
    innerElementProps = {},
    withClose = true,
    spritemap,
    ...otherProps
  } = _ref5;
  return /*#__PURE__*/_react.default.createElement(OldLabel, _extends({
    dismissible: withClose && !!closeButtonProps
  }, otherProps, {
    ref: ref
  }), !withClose && children, withClose && /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(ItemExpand, _extends({}, innerElementProps, {
    href: href
  }), children), closeButtonProps && /*#__PURE__*/_react.default.createElement(ItemAfter, null, /*#__PURE__*/_react.default.createElement("button", _extends({}, closeButtonProps, {
    className: (0, _classnames.default)(closeButtonProps.className, 'close'),
    type: "button"
  }), /*#__PURE__*/_react.default.createElement(_icon.default, {
    spritemap: spritemap,
    symbol: "times-small"
  })))));
});
Label.displayName = 'ClayLabel';
Label.ItemAfter = ItemAfter;
Label.ItemBefore = ItemBefore;
Label.ItemExpand = ItemExpand;
var _default = exports.default = Label;